/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.tabs.bars.growing;

import de.duehl.basics.debug.Assure;
import de.duehl.swing.ui.buttons.painted.PlusButton;
import de.duehl.swing.ui.tabs.bars.growing.TabCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GrowingTabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = 1L;
    private final TabCreator tabCreator;

    public GrowingTabbedPane(TabCreator tabCreator) {
        this(tabCreator, 1, 0);
    }

    public GrowingTabbedPane(TabCreator tabCreator, int n, int n2) {
        super(n, n2);
        Assure.notNull("Der Tab-Erzeuger", tabCreator);
        this.tabCreator = tabCreator;
        this.addPlusButton();
    }

    private void addPlusButton() {
        this.addTabWithoutContentForPlusButton();
        JPanel jPanel = this.createOpaquePanelForAddButonPanel();
        this.setTabComponentAt(this.getTabCount() - 1, jPanel);
    }

    private void addTabWithoutContentForPlusButton() {
        super.addTab("test", null);
    }

    private JPanel createOpaquePanelForAddButonPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setOpaque(false);
        jPanel.add((Component)this.createAddTabButton(), "Center");
        return jPanel;
    }

    private JButton createAddTabButton() {
        PlusButton plusButton = new PlusButton();
        plusButton.setFocusPainted(false);
        plusButton.setFocusable(false);
        plusButton.addActionListener(actionEvent -> this.addTabButtonAction());
        return plusButton;
    }

    private void addTabButtonAction() {
        String string = "new " + String.valueOf(this.getTabCount());
        this.createNewTab(string);
    }

    private void createNewTab(String string) {
        this.tabCreator.createTab(string);
    }

    @Override
    public void addTab(String string, Component component) {
        int n = this.getTabCount();
        int n2 = n - 1;
        this.insertTab(string, null, component, null, n2);
        this.setSelectedIndex(n2);
    }
}

