/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.timer;

import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.dragndrop.ChangeInformer;
import de.duehl.swing.ui.highlightingeditor.multiplereactor.ChangeReactor;
import de.duehl.swing.ui.timer.WaitingUserInputTimerOperator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class WaitingUserInputTimerForSelections
extends WaitingUserInputTimerOperator
implements ChangeReactor {
    private static final long MILLISECONDS_BEFORE_REACTION = 250L;
    protected final ChangeInformer changeInformer;
    private boolean reactOnChanges;

    public WaitingUserInputTimerForSelections(ChangeInformer changeInformer) {
        super(250L);
        this.changeInformer = changeInformer;
    }

    public void addJTextField(JTextField jTextField) {
        Document document = jTextField.getDocument();
        document.addDocumentListener(this.createWaitingDocumentListener());
    }

    public void addStringSelection(StringSelection stringSelection) {
        stringSelection.addTextFieldDocumentListener(this.createWaitingDocumentListener());
    }

    private DocumentListener createWaitingDocumentListener() {
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.warnAboutUserInput();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.warnAboutUserInput();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.warnAboutUserInput();
            }

            private void warnAboutUserInput() {
                if (WaitingUserInputTimerForSelections.this.reactOnChanges) {
                    WaitingUserInputTimerForSelections.this.reactOnDocumentChanges();
                }
            }
        };
    }

    private void reactOnDocumentChanges() {
        this.startTimer();
    }

    @Override
    public void reactOnChanges() {
        this.reactOnChanges = true;
    }

    @Override
    public void doNotReactOnChanges() {
        this.reactOnChanges = false;
    }

    @Override
    protected Runnable createRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(() -> WaitingUserInputTimerForSelections.this.changeInformer.informAboutChangingData());
            }
        };
    }
}

