/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.data.symbol;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.List;

public enum Kanji {
    FISCH("\u9b5a", "Fisch", "\u9b5a", "\u3055\u304b\u306a", 290, 112, CollectionsHelper.buildListFrom("GYO"), CollectionsHelper.buildListFrom("sakana", "uo")),
    FLEISCH("\u8089", "Fleisch", "\u8089", "\u306b\u304f", 223, 102, CollectionsHelper.buildListFrom("NIKU"), CollectionsHelper.buildListFrom(new String[0])),
    EI("\u5375", "Ei", "\u5375", "\u305f\u307e\u3054", 1103, 228, CollectionsHelper.buildListFrom("RAN"), CollectionsHelper.buildListFrom("tamago")),
    WASSER("\u6c34", "Wasser", "\u6c34", "\u307f\u305a", 21, 73, CollectionsHelper.buildListFrom("SUI"), CollectionsHelper.buildListFrom("mizu")),
    ESSEN("\u98df", "essen", "\u98df\u3079\u308b", "\u305f\u3079\u308b", 322, 116, CollectionsHelper.buildListFrom("SHOKU", "[JIKI]"), CollectionsHelper.buildListFrom("ta(beru)", "ku(u)", "ku(rau)")),
    TRINKEN("\u98f2", "trinken", "\u98f2\u3080", "\u306e\u3080", 323, 117, CollectionsHelper.buildListFrom("IN"), CollectionsHelper.buildListFrom("no(mu)")),
    GROSS("\u5927", "gro\u00df", "\u5927\u304d\u3044", "\u3061\u3044\u3055\u3044", 26, 74, CollectionsHelper.buildListFrom("DAI", "TAI"), CollectionsHelper.buildListFrom("oo(kii)", "oo-", "oo(ini)")),
    KLEIN("\u5c0f", "klein", "\u5c0f\u3055\u3044", "\u3061\u3044\u3055\u3044", 27, 74, CollectionsHelper.buildListFrom("SHOU"), CollectionsHelper.buildListFrom("chii(sai)", "ko-", "o-")),
    NEU("\u65b0", "neu", "\u65b0\u3057\u3044", "\u3042\u305f\u3089\u3057\u3044", 174, 95, CollectionsHelper.buildListFrom("SHIN"), CollectionsHelper.buildListFrom("atara(shii)", "ara(ta)", "nii-")),
    ALT("\u53e4", "alt", "\u53e4\u3044", "\u3075\u308b\u3044", 172, 95, CollectionsHelper.buildListFrom("KO"), CollectionsHelper.buildListFrom("furu(i)", "furu(su)")),
    TAG_SONNE("\u65e5", "Tag, Sonne", "\u65e5", "\u306b\u3061", 5, 71, CollectionsHelper.buildListFrom("NICHI", "JITSU"), CollectionsHelper.buildListFrom("hi", "ka")),
    BUCH_URSPRUNG("\u672c", "Buch, Ursprung, Haupt-", "\u672c", "\u307b\u3093", 25, 74, CollectionsHelper.buildListFrom("HON"), CollectionsHelper.buildListFrom("moto")),
    PERSON_MENSCH("\u4eba", "Person, Mensch", "\u4eba", "\u3072\u3068", 1, 71, CollectionsHelper.buildListFrom("JIN", "NIN"), CollectionsHelper.buildListFrom("hito")),
    GEHEN_FAHREN("\u884c", "gehen, fahren, fliegen", "\u884c\u304f", "\u3044\u304f", 68, 80, CollectionsHelper.buildListFrom("KOU", "[AN]", "GYOU"), CollectionsHelper.buildListFrom("i(ku)", "yu(ku)", "okona(u)")),
    ELEKTRIZITAET("\u96fb", "Elektrizit\u00e4t", "\u96fb\u8eca", "\u3067\u3093\u3057\u3083", 108, 86, CollectionsHelper.buildListFrom("DEN"), CollectionsHelper.buildListFrom(new String[0])),
    AUTO_WAGEN_RAD("\u8eca", "Auto, Wagen, Rad", "\u8eca", "\u304f\u308b\u307e", 133, 89, CollectionsHelper.buildListFrom("SHA"), CollectionsHelper.buildListFrom("kuruma")),
    FRAU("\u5973", "Frau", "\u5973", "\u304a\u3093\u306a", 102, 85, CollectionsHelper.buildListFrom("JO", "NYO", "[NYOU]"), CollectionsHelper.buildListFrom("onna", "me")),
    MANN("\u7537", "Mann", "\u7537", "\u304a\u3068\u3053", 101, 85, CollectionsHelper.buildListFrom("DAN", "NAN"), CollectionsHelper.buildListFrom("otoko")),
    SPRECHEN("\u8a71", "sprechen, reden", "\u8a71\u3059", "\u306f\u306a\u3059", 238, 104, CollectionsHelper.buildListFrom("WA"), CollectionsHelper.buildListFrom("hanashi", "hana(su)")),
    SICH_TREFFEN("\u4f1a", "sich treffen, sich versammeln", "\u4f1a\u3046", "\u3042\u3046", 158, 93, CollectionsHelper.buildListFrom("KAI", "E"), CollectionsHelper.buildListFrom("a(u)")),
    SICH_AUSRUHEN("\u4f11", "sich ausruhen", "\u4f11\u3080", "\u4f11", 60, 79, CollectionsHelper.buildListFrom("KYUU"), CollectionsHelper.buildListFrom("yasu(mu)", "yasu(meru)", "yasu(maru)")),
    SEHEN_ANSEHEN("\u898b", "sehen, ansehen", "\u898b\u308b", "\u307f\u308b", 63, 79, CollectionsHelper.buildListFrom("KEN"), CollectionsHelper.buildListFrom("mi(ru)", "mi(eru)", "mi(seru)")),
    HIMMEL_PARADIES("\u5929", "Himmel, Paradies", "\u5929\u6c17", "\u3066\u3093\u304d", 141, 91, CollectionsHelper.buildListFrom("TEN"), CollectionsHelper.buildListFrom("ame", "[ama]")),
    GEIST_SEELE_ENERGIE("\u6c17", "Geist, Seele, Energie", "\u5143\u6c17", "\u3052\u3093\u304d", 134, 90, CollectionsHelper.buildListFrom("KI", "KE"), CollectionsHelper.buildListFrom(new String[0])),
    STADT_ORTSCHAFT("\u753a", "Stadt, Ortschaft", "\u753a", "\u307e\u3061", 182, 96, CollectionsHelper.buildListFrom("CHOU"), CollectionsHelper.buildListFrom("machi")),
    LERNEN("\u5b66", "lernen", "\u5927\u5b66", "\u3060\u3044\u304c\u304f", 109, 86, CollectionsHelper.buildListFrom("GAKU"), CollectionsHelper.buildListFrom("mana(bu)")),
    BLUME("\u82b1", "Blume", "\u82b1", "\u306f\u306a", 255, 107, CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom("hana")),
    JETZT("\u4eca", "jetzt", "\u4eca", "\u3044\u307e", 51, 78, CollectionsHelper.buildListFrom("KON", "KIN"), CollectionsHelper.buildListFrom("ima")),
    ZEIT_STUNDE("\u6642", "Zeit, Stunde, ... Uhr", "\u6642", "\u3058", 42, 76, CollectionsHelper.buildListFrom("JI"), CollectionsHelper.buildListFrom("toki")),
    TEILEN_VERSTEHEN_TEIL_MINUTE("\u5206", "teilen, Teil, Minute, verstehen", "\u5206\u304b\u308b", "\u308f\u304b\u308b", 38, 76, CollectionsHelper.buildListFrom("BUN", "BU", "FUN", "PUN"), CollectionsHelper.buildListFrom("wa(keru)", "wa(katsu)", "wa(kareru)", "wa(karu)")),
    SPITZE_ZUVOR("\u5148", "Spitze, zuvor", "\u5148", "\u3055\u304d", 50, 78, CollectionsHelper.buildListFrom("SEN"), CollectionsHelper.buildListFrom("saki")),
    GEBAEREN_LEBEN("\u751f", "geb\u00e4ren, leben", "\u751f\u3080", "\u3046\u3080", 44, 77, CollectionsHelper.buildListFrom("SEI", "SHOU"), CollectionsHelper.buildListFrom("i(kiru)", "i(keru)", "i(kasu)", "u(mu)", "ha(yasu)", "ha(eru)", "o(u)")),
    SPRACHE("\u8a9e", "Sprache", "\u8a9e", "\u3054", 67, 80, CollectionsHelper.buildListFrom("GO"), CollectionsHelper.buildListFrom("kata(ru)", "kata(rau)")),
    REGEN("\u96e8", "Regen", "\u96e8", "\u3042\u3081", 30, 75, CollectionsHelper.buildListFrom("U"), CollectionsHelper.buildListFrom("ame", "[ama]")),
    KOMMEN("\u6765", "kommen", "\u6765\u308b", "\u304f\u308b", 69, 80, CollectionsHelper.buildListFrom("RAI"), CollectionsHelper.buildListFrom("ku(ru)", "kita(ru)", "kita(su)")),
    FEUER("\u706b", "Feuer", "\u706b", "\u3072", 20, 73, CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom("hi", "[ho]")),
    BAUM_HOLZ("\u6728", "Baum, Holz", "\u6728", "\u304d", 22, 74, CollectionsHelper.buildListFrom("BOKU", "MOKU"), CollectionsHelper.buildListFrom("ki", "[ka]")),
    WENIG("\u5c11", "wenig", "\u5c11\u3057", "\u3059\u3053\u3057", 144, 91, CollectionsHelper.buildListFrom("SHOU"), CollectionsHelper.buildListFrom("suko(shi)", "suku(nai)")),
    VIEL_ZAHLREICH("\u591a", "viel,  zahlreich", "\u591a\u3044", "\u304a\u304a\u3044", 229, 103, CollectionsHelper.buildListFrom("TA"), CollectionsHelper.buildListFrom("oo(i)")),
    WAS("\u4f55", "was", "\u4f55", "\u306a\u306b", 392, 126, CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom("nani", "[nan]")),
    HOEREN_FRAGEN("\u805e", "h\u00f6ren, fragen", "\u805e\u304f", "\u304d\u304f", 64, 80, CollectionsHelper.buildListFrom("BUN", "MON"), CollectionsHelper.buildListFrom("ki(ku)", "ki(koru)")),
    KAUFEN("\u8cb7", "kaufen", "\u8cb7\u3046", "\u304b\u3046", 241, 105, CollectionsHelper.buildListFrom("BAI"), CollectionsHelper.buildListFrom("ka(u)")),
    HOCH_TEUER("\u9ad8", "hoch, teuer", "\u9ad8\u3044", "\u305f\u304b\u3044", 190, 98, CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom("taka(i)", "taka", "taka(maru)", "taka(meru)")),
    BILLIG_SICHER("\u5b89", "billig, (sicher)", "\u5b89\u3044", "\u3084\u3059\u3044", 105, 85, CollectionsHelper.buildListFrom("AN"), CollectionsHelper.buildListFrom("yasu(i)")),
    KIND("\u5b50", "Kind", "\u5b50\u4f9b", "\u3053\u3069\u3082", 103, 85, CollectionsHelper.buildListFrom("SHI", "SU"), CollectionsHelper.buildListFrom("ko")),
    WEISS("\u767d", "Wei\u00df", "\u767d", "\u3057\u308d", 205, 100, CollectionsHelper.buildListFrom("HAKU", "BYAKU"), CollectionsHelper.buildListFrom("shiro(i)", "shiro")),
    LADEN_GESCHAEFT("\u5e97", "Laden, Gesch\u00e4ft", "\u5e97", "\u307f\u305b", 168, 94, CollectionsHelper.buildListFrom("TEN"), CollectionsHelper.buildListFrom("mise")),
    MOND_MONAT("\u6708", "Mond, Monat", "\u6708", "\u3064\u304d", 17, 73, CollectionsHelper.buildListFrom("GETSU", "GATSU"), CollectionsHelper.buildListFrom("tsuki")),
    FUENF_5("\u4e94", "f\u00fcnf, 5", "\u4e94", "\u3054", 7, 71, CollectionsHelper.buildListFrom("GO"), CollectionsHelper.buildListFrom("itsu(tsu)", "itsu-")),
    MITTE_INNEN("\u4e2d", "Mitte, innen", "\u4e2d", "\u306a\u304b", 28, 74, CollectionsHelper.buildListFrom("CHUU", "-CHUU", "-JUU"), CollectionsHelper.buildListFrom("naka")),
    MITTAG("\u5348", "Mittag", "\u5348\u5f8c", "\u3054\u3054", 49, 77, CollectionsHelper.buildListFrom("GO"), CollectionsHelper.buildListFrom(new String[0])),
    EINS_1("\u4e00", "eins, 1", "\u4e00", "\u3044\u3061", 2, 71, CollectionsHelper.buildListFrom("ICHI", "ITSU"), CollectionsHelper.buildListFrom("hito(tsu)", "hito-")),
    ZWEI_2("\u4e8c", "zwei, 2", "\u4e8c", "\u306b", 3, 71, CollectionsHelper.buildListFrom("NI"), CollectionsHelper.buildListFrom("futa(tsu)", "futa-")),
    DREI_3("\u4e09", "drei, 3", "\u4e09", "\u3054", 4, 71, CollectionsHelper.buildListFrom("SAN"), CollectionsHelper.buildListFrom("mit(tsu)", "mi(tsu)", "mi-")),
    VIER_4("\u56db", "vier, 4", "\u56db", "\u3057", 6, 71, CollectionsHelper.buildListFrom("SHI"), CollectionsHelper.buildListFrom("yot(tsu)", "yo(tsu)", "yo-", "yon")),
    SECHS_6("\u516d", "sechs, 6", "\u516d", "\u308d\u304f", 8, 72, CollectionsHelper.buildListFrom("ROKU"), CollectionsHelper.buildListFrom("mut(tsu)", "mu(tsu)", "mu-", "[mui-]")),
    SIEBEN_7("\u4e03", "sieben, 7", "\u4e03", "\u306a\u306a", 9, 72, CollectionsHelper.buildListFrom("SHICHI"), CollectionsHelper.buildListFrom("nana(tsu)", "nana-", "[nano-]")),
    ACHT_8("\u516b", "acht, 8", "\u516b", "\u306f\u3061", 10, 72, CollectionsHelper.buildListFrom("HACHI"), CollectionsHelper.buildListFrom("yat(tsu)", "ya(tsu)", "ya-", "[yo-]")),
    NEUN_9("\u4e5d", "neun, 9", "\u4e5d", "\u304d\u3085\u3046", 11, 72, CollectionsHelper.buildListFrom("KYUU", "KU"), CollectionsHelper.buildListFrom("kokono(tsu)", "kokono-")),
    ZEHN_10("\u5341", "zehn, 10", "\u5341", "\u3058\u3085\u3046", 12, 72, CollectionsHelper.buildListFrom("JUU", "JI'"), CollectionsHelper.buildListFrom("tou", "to-")),
    HUNDERT_100("\u767e", "hundert, 100", "\u767e", "\u3072\u3085\u304f", 14, 72, CollectionsHelper.buildListFrom("HYAKU"), CollectionsHelper.buildListFrom(new String[0])),
    TAUSEND_1000("\u5343", "tausend, 1000", "\u5343", "\u305b\u3093", 15, 73, CollectionsHelper.buildListFrom("SEN"), CollectionsHelper.buildListFrom("chi-")),
    GOLD("\u91d1", "Gold, Metall, Geld", "\u91d1", "\u304d\u3093", 23, 74, CollectionsHelper.buildListFrom("KIN", "KON"), CollectionsHelper.buildListFrom("kane", "[kana]")),
    BODEN_ERDE_GRUND("\u571f", "Boden, Erde, Grund", "\u571f", "\u3069", 24, 74, CollectionsHelper.buildListFrom("DO", "TO"), CollectionsHelper.buildListFrom("tsuchi")),
    OBEN_RAUF_UEBER("\u4e0a", "oben, rauf, \u00fcber", "\u4e0a", "\u3046\u3048", 32, 75, CollectionsHelper.buildListFrom("JOU", "[SHOU]"), CollectionsHelper.buildListFrom("ue", "kami", "[uwa-]", "a(geru)", "nobo(ru)", "nobo(seru)", "nobo(su)")),
    UNTEN_RUNTER_UNTER("\u4e0b", "unten, runter, unter", "\u4e0b", "\u3057\u305f", 31, 75, CollectionsHelper.buildListFrom("KA", "GE"), CollectionsHelper.buildListFrom("shita", "moto", "shimo", "sa(geru)", "o(riru)", "kuda(ru)", "kuda(saru)")),
    LINKS("\u5de6", "links", "\u5de6", "\u3072\u3060\u308a", 75, 81, CollectionsHelper.buildListFrom("SA"), CollectionsHelper.buildListFrom("hidari")),
    RECHTS("\u53f3", "rechts", "\u53f3", "\u307f\u304e", 76, 81, CollectionsHelper.buildListFrom("U", "YUU"), CollectionsHelper.buildListFrom("migi")),
    KREIS_YEN_RUND("\u5186", "Kreis, Yen, rund", "\u5186", "\u3048\u3093", 13, 72, CollectionsHelper.buildListFrom("EN"), CollectionsHelper.buildListFrom("maru(i)")),
    AUGE("\u76ee", "Auge", "\u76ee", "\u3081", 55, 78, CollectionsHelper.buildListFrom("MOKU", "[BOKU]"), CollectionsHelper.buildListFrom("me", "[ma]")),
    HAELFTE_HALB("\u534a", "H\u00e4lfte, Halb-, halb, halb nach", "\u534a", "\u306f\u3093", 88, 83, CollectionsHelper.buildListFrom("HAN"), CollectionsHelper.buildListFrom("naka(ba)")),
    OHR("\u8033", "Ohr", "\u8033", "\u307f\u307f", 56, 78, CollectionsHelper.buildListFrom("JI"), CollectionsHelper.buildListFrom("mimi")),
    MUND("\u53e3", "Mund", "\u53e3", "\u304f\u3061", 54, 78, CollectionsHelper.buildListFrom("KOU", "KU"), CollectionsHelper.buildListFrom("kuchi")),
    HAND("\u624b", "Hand", "\u624b", "\u3066", 57, 79, CollectionsHelper.buildListFrom("SHU"), CollectionsHelper.buildListFrom("te", "[ta]")),
    BEIN_FUSS("\u8db3", "Bein, Fu\u00df", "\u8db3", "\u3042\u3057", 58, 79, CollectionsHelper.buildListFrom("SOKU"), CollectionsHelper.buildListFrom("ashi", "ta(ru)", "ta(iru)", "ta(su)")),
    KRAFT("\u529b", "Kraft", "\u529b", "\u3061\u304b\u3089", 100, 85, CollectionsHelper.buildListFrom("RYOKU", "RIKI"), CollectionsHelper.buildListFrom("chikara")),
    STEHEN_AUFSTEHEN("\u7acb", "stehen, aufstehen, aufstellen", "\u7acb\u3064", "\u305f\u3064", 121, 88, CollectionsHelper.buildListFrom("RITSU", "[RYUU]"), CollectionsHelper.buildListFrom("ta(tsu)", "ta(teru)")),
    HIMMEL_LEER("\u7a7a", "Himmel, leer", "\u7a7a", "\u305d\u3089", 140, 90, CollectionsHelper.buildListFrom("KUU"), CollectionsHelper.buildListFrom("sora", "a(keru)", "a(ku)", "kara")),
    BERG("\u5c71", "Berg", "\u5c71", "\u3084\u307e", 34, 75, CollectionsHelper.buildListFrom("SAN"), CollectionsHelper.buildListFrom("yama")),
    FLUSS("\u5ddd", "Fluss", "\u5ddd", "\u304b\u308f", 33, 75, CollectionsHelper.buildListFrom("SEN"), CollectionsHelper.buildListFrom("kawa")),
    WORT_SAGEN("\u8a00", "Wort, sagen", "\u8a00\u3046", "\u3044\u3046", 66, 80, CollectionsHelper.buildListFrom("GEN", "GON"), CollectionsHelper.buildListFrom("-koto", "i(u)")),
    LESEN("\u8aad", "lesen", "\u8aad\u3080", "\u3088\u3080", 244, 105, CollectionsHelper.buildListFrom("DOKU", "TOKU", "[TOU]"), CollectionsHelper.buildListFrom("yo(mu)")),
    SCHREIBEN("\u66f8", "schreiben", "\u66f8\u304f", "\u304b\u304f", 131, 89, CollectionsHelper.buildListFrom("SHO"), CollectionsHelper.buildListFrom("ka(ku)")),
    WAELCHEN_WALD_FORST("\u6797", "W\u00e4ldchen, Wald, Forst", "\u6797", "\u306f\u3084\u3057", 127, 89, CollectionsHelper.buildListFrom("RIN"), CollectionsHelper.buildListFrom("hayashi")),
    WALD_FORST("\u68ee", "Wald, Forst", "\u68ee", "\u3082\u308a", 128, 89, CollectionsHelper.buildListFrom("SHIN"), CollectionsHelper.buildListFrom("mori")),
    STEIN("\u77f3", "Stein", "\u77f3", "\u3044\u3057", 78, 82, CollectionsHelper.buildListFrom("SEKI", "[SHAKU]", "[KOKU]"), CollectionsHelper.buildListFrom("ishi")),
    HUND("\u72ac", "Hund", "\u72ac", "\u3044\u306c", 280, 110, CollectionsHelper.buildListFrom("KEN"), CollectionsHelper.buildListFrom("inu")),
    INSEKT_WURM("\u866b", "Insekt, Wurm", "\u866b", "\u3080\u3057", 893, 198, CollectionsHelper.buildListFrom("CHUU"), CollectionsHelper.buildListFrom("mushi")),
    JAHR("\u5e74", "Jahr", "\u5e74", "\u306d\u3093", 45, 77, CollectionsHelper.buildListFrom("NEN"), CollectionsHelper.buildListFrom("toshi")),
    DORF("\u6751", "Dorf", "\u6751", "\u3080\u3089", 191, 98, CollectionsHelper.buildListFrom("SON"), CollectionsHelper.buildListFrom("mura")),
    REISFELD("\u7530", "Reisfeld, Feld", "\u7530", "\u305f", 35, 75, CollectionsHelper.buildListFrom("DEN"), CollectionsHelper.buildListFrom("ta")),
    ABEND("\u5915", "Abend, Nacht", "\u5915\u3079", "\u3086\u3046\u3079", 81, 82, CollectionsHelper.buildListFrom("SEKI"), CollectionsHelper.buildListFrom("yuu")),
    ROT("\u8d64", "rot", "\u8d64", "\u3042\u304b", 207, 100, CollectionsHelper.buildListFrom("SEKI", "[SHAKU]"), CollectionsHelper.buildListFrom("aka(i)", "aka", "aka(ramu)", "aka(rameru)")),
    BLAU("\u9752", "gr\u00fcn, blau, unreif", "\u9752", "\u3042\u304a", 208, 100, CollectionsHelper.buildListFrom("SEI", "[SHOU]"), CollectionsHelper.buildListFrom("ao(i)", "ao")),
    HERAUSNEHMEN_HERAUSKOMMEN("\u51fa", "herausnehmen, abschicken, hinausgehen, herauskommen", "\u51fa\u53e3", "\u3067\u3050\u3061", 53, 78, CollectionsHelper.buildListFrom("SHUTSU", "[SUI]"), CollectionsHelper.buildListFrom("da(su)", "de(ru)")),
    HINEINGEHEN_EINLASSEN("\u5165", "hineingehen, eintreten, hereinstecken, einlassen", "\u5165\u308a\u53e3", "\u3044\u308a\u3050\u3061", 52, 78, CollectionsHelper.buildListFrom("NYUU"), CollectionsHelper.buildListFrom("hai(ru)", "i(ru)", "i(eru)")),
    FRUEH_SCHNELL("\u65e9", "fr\u00fch, schnell", "\u65e9\u3044", "\u306f\u3084\u3044", 248, 106, CollectionsHelper.buildListFrom("SOU", "[SA']"), CollectionsHelper.buildListFrom("haya(i)", "haya(maru)", "haya(meru)")),
    SATZ_TEXT_LITERATUR_BRIEF("\u6587", "Satz, Text, Literatur, Brief", "\u6587\u5b66", "\u3076\u3093\u304c\u304f", 111, 86, CollectionsHelper.buildListFrom("BUN", "MON"), CollectionsHelper.buildListFrom("fumi")),
    NORDEN("\u5317", "Norden", "\u5317", "\u304d\u305f", 73, 81, CollectionsHelper.buildListFrom("HOKU"), CollectionsHelper.buildListFrom("kita")),
    OSTEN("\u6771", "Osten", "\u6771", "\u3072\u304c\u3057", 71, 81, CollectionsHelper.buildListFrom("TOU"), CollectionsHelper.buildListFrom("higashi")),
    SUEDEN("\u5357", "S\u00fcden", "\u5357", "\u307f\u306a\u307f", 74, 81, CollectionsHelper.buildListFrom("NAN", "[NA]"), CollectionsHelper.buildListFrom("minami")),
    WESTEN("\u897f", "Westen", "\u897f", "\u306b\u3057", 72, 81, CollectionsHelper.buildListFrom("SEI", "SAI"), CollectionsHelper.buildListFrom("nishi")),
    NAME_RUF_REPUTATION("\u540d", "Name, Ruf, Reputation", "\u540d\u524d", "\u306a\u307e\u3048", 82, 82, CollectionsHelper.buildListFrom("MEI", "MYOU"), CollectionsHelper.buildListFrom("na")),
    SCHRIFTZEICHEN_BUCHSTABE("\u5b57", "Schriftzeichen, Buchstabe", "\u6587\u5b57", "\u3082\u3058", 110, 86, CollectionsHelper.buildListFrom("JI"), CollectionsHelper.buildListFrom("aza")),
    SCHULE_KORREKTUR("\u6821", "Schule, Korrektur", "\u5b66\u6821", "\u304c\u3063\u3053\u3046", 115, 87, CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom(new String[0])),
    RICHTIG_GERECHT("\u6b63", "richtig, gerecht", "\u6b63\u3059", "\u305f\u3060\u3059", 275, 110, CollectionsHelper.buildListFrom("SEI", "SHOU"), CollectionsHelper.buildListFrom("tada(shii)", "tada(su)", "masa(ni)")),
    KOENIG("\u738b", "K\u00f6nig", "\u738b\u69d8", "\u304a\u3046\u3055\u307e", 294, 112, CollectionsHelper.buildListFrom("OU"), CollectionsHelper.buildListFrom(new String[0])),
    TON_LAUT("\u97f3", "Ton, Laut", "\u97f3\u697d", "\u304a\u3093\u304c\u304f", 347, 120, CollectionsHelper.buildListFrom("ON", "IN"), CollectionsHelper.buildListFrom("oto", "ne")),
    FADEN("\u7cf8", "Faden", "\u7cf8", "\u3044\u3068", 242, 105, CollectionsHelper.buildListFrom("SHI"), CollectionsHelper.buildListFrom("ito")),
    MUSCHEL("\u8c9d", "Muschel", "\u8c9d", "\u304b\u3044", 240, 105, CollectionsHelper.buildListFrom(new String[0]), CollectionsHelper.buildListFrom("kai")),
    KUGEL_BALL("\u7389", "Edelstein, Juwel, Kugel, Ball", "\u7389", "\u305f\u307e", 295, 113, CollectionsHelper.buildListFrom("GYOKU"), CollectionsHelper.buildListFrom("tama")),
    GRAS_KRAUT("\u8349", "Gras, Kraut, Entwurf", "\u8349", "\u304f\u3055", 249, 106, CollectionsHelper.buildListFrom("SOU"), CollectionsHelper.buildListFrom("kusa")),
    BAMBUS("\u7af9", "Bambus", "\u7af9", "\u305f\u3051", 129, 89, CollectionsHelper.buildListFrom("CHIKU"), CollectionsHelper.buildListFrom("take")),
    ZEHNTAUSEND("\u4e07", "10000, 10.000, zehntausend, Myriaden, viele , alle", "\u4e07", "\u307e\u3093", 16, 73, CollectionsHelper.buildListFrom("MAN", "BAN"), CollectionsHelper.buildListFrom(new String[0])),
    ZIEHEN_BILLIGER_MACHEN("\u5f15", "ziehen, anziehen, schlie\u00dfen, billiger machen", "\u5f15\u304f", "\u3072\u304f", 216, 101, CollectionsHelper.buildListFrom("IN"), CollectionsHelper.buildListFrom("hi(ku)")),
    WOLKE("\u96f2", "Wolke", "\u96f2", "\u304f\u3082", 646, 163, CollectionsHelper.buildListFrom("UN"), CollectionsHelper.buildListFrom("kumo")),
    WEIT_FERN_ENTFERNT("\u9060", "weit, fern, entfernt", "\u9060\u3044", "\u3068\u304a\u3044", 453, 135, CollectionsHelper.buildListFrom("EN", "[ON]"), CollectionsHelper.buildListFrom("too(i)")),
    LEHRFACH("\u79d1", "Lehrfach, Abteilung, Fakult\u00e4t, Schulfach", "\u79d1\u5b66", "\u304b\u304c\u304f", 320, 116, CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom(new String[0])),
    SOMMER("\u590f", "Sommer", "\u590f", "\u306a\u3064", 469, 137, CollectionsHelper.buildListFrom("KA", "[GE]"), CollectionsHelper.buildListFrom("natsu")),
    HAN_CHINA("\u6f22", "Han, China, Mann, Kerl", "\u6f22\u5b57", "\u304b\u3093\u3058", 565, 151, CollectionsHelper.buildListFrom("KAN"), CollectionsHelper.buildListFrom(new String[0])),
    HAUPTSTADT("\u4eac", "Hauptstadt", "\u4eac\u90fd", "\u304d\u3087\u3046\u3068", 189, 97, CollectionsHelper.buildListFrom("KYOU", "KEI"), CollectionsHelper.buildListFrom(new String[0])),
    LICHT_HELL("\u660e", "Licht, hell, Helligkeit", "\u660e\u304b\u308a", "\u3042\u304b\u308a", 18, 73, CollectionsHelper.buildListFrom("MEI", "MYOU"), CollectionsHelper.buildListFrom("a(kari)", "aka(rui)", "aki(raka)", "a(keru)", "aka(rumu)", "aka(ramu)", "a(ku)", "a(kasu)", "a(kuru)")),
    HAUS_HEIM("\u5bb6", "Haus, Heim", "\u5bb6", "\u3044\u3048", 165, 94, CollectionsHelper.buildListFrom("KA", "KE"), CollectionsHelper.buildListFrom("ie", "ya")),
    GEDICHT_LIED_SINGEN("\u6b4c", "Gedicht, Lied, singen", "\u6b4c", "\u3046\u305f", 395, 127, CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom("uta", "uta(u)")),
    BILD_STRICH("\u753b", "Bild, Strich", "\u6620\u753b", "\u3048\u3044\u304c", 343, 119, CollectionsHelper.buildListFrom("GA", "KAKU"), CollectionsHelper.buildListFrom(new String[0])),
    MAL_WIEDERKEHR_WEITERGABE_DREHEN("\u56de", "Mal, Wiederkehr, Weitergabe, drehen", "\u4e00\u56de", "\u3044\u3063\u304b\u3044", 90, 83, CollectionsHelper.buildListFrom("KAI", "[E]"), CollectionsHelper.buildListFrom("mawa(su)", "mawa(ru)")),
    MEER_SEE("\u6d77", "Meer, See", "\u6d77", "\u3046\u307f", 117, 87, CollectionsHelper.buildListFrom("KAI"), CollectionsHelper.buildListFrom("umi")),
    JEDER_JEDES("\u6bce", "jeder, jeden, jedes", "\u6bce\u65e5", "\u307e\u3044\u306b\u3061", 116, 87, CollectionsHelper.buildListFrom("MAI"), CollectionsHelper.buildListFrom(new String[0])),
    EINZELSTUECK("\u7b87", "Einzelst\u00fcck, St\u00fcck", "\u7b87\u6240", "\u304b\u3057\u3087", 1570, 295, CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom(new String[0])),
    EINZELSTUECK_KURZFORM("\u30f6", "Einzelst\u00fcck, St\u00fcck", "\u4e00\u30f6\u6708", "\u3044\u3063\u304b\u3052\u3064", 1570, 295, CollectionsHelper.buildListFrom("KA"), CollectionsHelper.buildListFrom(new String[0])),
    ICH_PRIVAT("\u79c1", "ich, privat", "\u79c1", "\u308f\u305f\u3057", 125, 88, CollectionsHelper.buildListFrom("SHI"), CollectionsHelper.buildListFrom("watakushi", "watashi")),
    KATZE("\u732b", "Katze", "\u732b", "\u306d\u3053", 1567, 294, CollectionsHelper.buildListFrom("BYOU"), CollectionsHelper.buildListFrom("neko")),
    BAHNHOF("\u99c5", "Bahnhof", "\u99c5", "\u3048\u304d", 284, 111, CollectionsHelper.buildListFrom("EKI"), CollectionsHelper.buildListFrom(new String[0])),
    OEFFENTLICH_OFFIZIELL("\u516c", "\u00f6ffentlich, offiziell", "\u516c\u5712", "\u3053\u3046\u3048\u3093", 126, 88, CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom("ooyake")),
    GARTEN_PARK("\u5712", "Garten, Park", "\u516c\u5712", "\u3053\u3046\u3048\u3093", 454, 135, CollectionsHelper.buildListFrom("EN"), CollectionsHelper.buildListFrom("sono")),
    AUSSENSEITE_DRAUSSEN("\u5916", "Au\u00dfenseite, drau\u00dfen", "\u5916", "\u305d\u3068", 83, 82, CollectionsHelper.buildListFrom("GAI", "GE"), CollectionsHelper.buildListFrom("soto", "hoka", "hazu(reru)", "hazu(su)")),
    ZEICHNUNG_PLAN("\u56f3", "Zeichnung, Plan, Skizze, planen", "\u56f3\u66f8\u9928", "\u3068\u3057\u3087\u304b\u3093", 339, 119, CollectionsHelper.buildListFrom("ZU", "TO"), CollectionsHelper.buildListFrom("haka(ru)")),
    GEBAUEDE_HALLE("\u9928", "gro\u00dfes Geb\u00e4ude, Geb\u00e4ude, Halle", "\u56f3\u66f8\u9928", "\u3068\u3057\u3087\u304b\u3093", 327, 117, CollectionsHelper.buildListFrom("KAN"), CollectionsHelper.buildListFrom("yakata")),
    MOEGEN_LIEBEN("\u597d", "gern haben, m\u00f6gen, lieben", "\u597d\u304d", "\u3059\u304d", 104, 85, CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom("kono(mu)", "su(ku)")),
    TEE("\u8336", "Teestrauch, Teebl\u00e4tter, Tee", "\u304a\u8336", "\u304a\u3061\u3083", 251, 106, CollectionsHelper.buildListFrom("CHA", "SA"), CollectionsHelper.buildListFrom(new String[0])),
    VOR_VORNE_FRUEHER("\u524d", "vorne, vor, fr\u00fcher", "\u524d", "\u307e\u3048", 47, 77, CollectionsHelper.buildListFrom("ZEN"), CollectionsHelper.buildListFrom("mae")),
    HINTER_DANACH_SPAETER("\u5f8c", "danach, sp\u00e4ter, R\u00fcckseite, hinten, nach, hinter, zur\u00fcck", "\u5f8c\u308d", "\u3046\u3057\u308d", 48, 77, CollectionsHelper.buildListFrom("GO", "KOU"), CollectionsHelper.buildListFrom("nochi", "ushi(ro)", "ato", "oku(reru)")),
    SPRACHE_DIALEKT_UNTERSCHEIDUNG_BLATT("\u5f01", "Sprache, Dialekt, Unterscheidung, Blatt", "\u5f01\u5f53", "\u3079\u3093\u3068\u3046", 724, 174, CollectionsHelper.buildListFrom("BEN"), CollectionsHelper.buildListFrom(new String[0])),
    TREFFEN_ZUTREFFEN("\u5f53", "treffen, zutreffen", "\u5f01\u5f53", "\u3079\u3093\u3068\u3046", 77, 81, CollectionsHelper.buildListFrom("TOU"), CollectionsHelper.buildListFrom("a(teru)", "a(taru)")),
    GOTTHEIT_GOTT("\u795e", "Gottheit, Gott", "\u795e", "\u304b\u307f", 310, 115, CollectionsHelper.buildListFrom("SHIN", "JIN"), CollectionsHelper.buildListFrom("kami", "[kan]", "[kou]")),
    SHINTO_SCHREIN_GESELLSCHAFT_FIRMA("\u793e", "Shinto-Schrein, Gesellschaft, Firma", "\u4f1a\u793e", "\u304b\u3044\u3057\u3083", 308, 114, CollectionsHelper.buildListFrom("SHA"), CollectionsHelper.buildListFrom("yashiro")),
    MACHEN_ANFERTIGEN("\u4f5c", "machen, anfertigen, zubereiten, herstellen", "\u4f5c\u308b", "\u3079\u3093\u3068\u3046", 361, 122, CollectionsHelper.buildListFrom("SAKU", "SA"), CollectionsHelper.buildListFrom("tsuku(ru)")),
    SCHLOSS_BURG("\u57ce", "Schloss, Burg", "\u57ce", "\u3057\u308d", 733, 175, CollectionsHelper.buildListFrom("JOU"), CollectionsHelper.buildListFrom("shiro")),
    TEMPEL("\u5bfa", "Tempel", "\u5bfa", "\u3066\u3089", 41, 76, CollectionsHelper.buildListFrom("JI"), CollectionsHelper.buildListFrom("tera")),
    ANSTRENGUNG_HARTE_ARBEIT("\u52c9", "Anstrengung, harte Arbeit", "\u52c9\u5f37", "\u3079\u3093\u304d\u3087\u3046", 748, 177, CollectionsHelper.buildListFrom("BEN"), CollectionsHelper.buildListFrom(new String[0])),
    STAR_STAERKER_WERDEN("\u5f37", "stark, st\u00e4rker werden, zwingen", "\u52c9\u5f37", "\u3079\u3093\u304d\u3087\u3046", 217, 101, CollectionsHelper.buildListFrom("KYOU", "GOU"), CollectionsHelper.buildListFrom("tsuyo(i)", "tsuyo(maru)", "tsuyo(meru)", "shi(iru)")),
    LEHREN_UNTERRICHTEN("\u6559", "lehren, unterrichten, lernen", "\u6559\u3048\u308b", "\u304a\u3057\u3048\u308b", 245, 105, CollectionsHelper.buildListFrom("KYOU"), CollectionsHelper.buildListFrom("oshi(eru)", "oso(waru)")),
    LAND_STAAT("\u56fd", "Land, Staat", "\u56fd", "\u304f\u306b", 40, 76, CollectionsHelper.buildListFrom("KOKU"), CollectionsHelper.buildListFrom("kuni")),
    EINSTEIGEN("\u4e57", "einsteigen, reiten, fahren", "\u4e57\u308b", "\u306e\u308b", 532, 146, CollectionsHelper.buildListFrom("JOU"), CollectionsHelper.buildListFrom("no(ru)", "no(seru)")),
    STADT_MARKT("\u5e02", "Stadt, Markt", "\u5e02", "\u3057", 181, 96, CollectionsHelper.buildListFrom("SHI"), CollectionsHelper.buildListFrom("ichi")),
    PRAEFEKTUR("\u770c", "Pr\u00e4fektur", "\u770c", "\u3051\u3093", 194, 98, CollectionsHelper.buildListFrom("KEN"), CollectionsHelper.buildListFrom(new String[0])),
    GESICHT_MASKE_FLAECHE("\u9762", "Gesicht, Maske, Fl\u00e4che, Oberfl\u00e4che, Seite", "\u9762\u767d\u3044", "\u304a\u3082\u3057\u308d\u3044", 274, 110, CollectionsHelper.buildListFrom("MEN"), CollectionsHelper.buildListFrom("omote", "omo", "tsura")),
    KOPF_URSPRUNG_ANFANG("\u5143", "Kopf, Ursprung, Anfang", "\u5143\u6c17", "\u3052\u3093\u304d", 137, 90, CollectionsHelper.buildListFrom("GEN", "GAN"), CollectionsHelper.buildListFrom("moto")),
    SEIN_EXISTIEREN("\u6709", "sein, existieren, sich befinden, haben", "\u6709\u540d", "\u3086\u3046\u3081\u3044", 265, 108, CollectionsHelper.buildListFrom("YUU", "U"), CollectionsHelper.buildListFrom("a(ru)")),
    SCHNEIDEN_ZU_ENDE_GEHEN("\u5207", "schneiden, gut schneiden, zu Ende gehen", "\u5927\u5207", "\u305f\u3044\u305b\u3064", 39, 76, CollectionsHelper.buildListFrom("SETSU", "[SAI]"), CollectionsHelper.buildListFrom("ki(ru)", "ki(eru)")),
    UEBERSCHREITEN_UEBERGEBEN("\u6e21", "\u00fcberschreiten, \u00fcbergeben", "\u6e21\u3059", "\u308f\u305f\u3059", 379, 125, CollectionsHelper.buildListFrom("TO"), CollectionsHelper.buildListFrom("wata(ru)", "wata(su)")),
    NEHMEN("\u53d6", "nehmen", "\u53d6\u308b", "\u3068\u308b", 65, 80, CollectionsHelper.buildListFrom("SHU"), CollectionsHelper.buildListFrom("to(ru)")),
    SETZEN_LEGEN_DALSSSEN("\u7f6e", "setzen, stellen, legen, dalassen, lassen, errichten", "\u7f6e\u304f", "\u304a\u304f", 432, 132, CollectionsHelper.buildListFrom("CHI"), CollectionsHelper.buildListFrom("o(ku)")),
    SCHNEE("\u96ea", "Schnee", "\u96ea", "\u3086\u304d", 979, 210, CollectionsHelper.buildListFrom("SETSU"), CollectionsHelper.buildListFrom("yuki")),
    FALLEN("\u964d", "fallen, herabsteigen, aussteigen, regnen, schneien", "\u964d\u308b", "\u3075\u308b", 977, 210, CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom("o(riru)", "o(rosu)", "fu(ru)")),
    WIND("\u98a8", "Wind, Aussehen, Mode, Stil", "\u98a8", "\u304b\u305c", 29, 75, CollectionsHelper.buildListFrom("FUU", "[FU]"), CollectionsHelper.buildListFrom("kaze", "[kaza]")),
    BLASEN_WEHEN("\u5439", "blasen, wehen", "\u5439\u304f", "\u3075\u304f", 1326, 260, CollectionsHelper.buildListFrom("SUI"), CollectionsHelper.buildListFrom("fu(ku)")),
    HEISS__WETTER_("\u6691", "hei\u00df, hei\u00df (Wetter)", "\u6691", "\u3042\u3064\u3044", 648, 163, CollectionsHelper.buildListFrom("SHO"), CollectionsHelper.buildListFrom("atsu(i)")),
    HITZE_FIEBER_HEISS("\u71b1", "Hitze, Fieber, hei\u00df, hei\u00df (anfassbar)", "\u71b1\u3044", "\u3042\u3064\u3044", 655, 164, CollectionsHelper.buildListFrom("NETSU"), CollectionsHelper.buildListFrom("atsu(i)")),
    KAELTE_WINTER_KALT("\u5bd2", "K\u00e4lte, kalte Jahreszeit, Winter, kalt", "\u5bd2\u3044", "\u3055\u3080\u3044", 464, 137, CollectionsHelper.buildListFrom("KAN"), CollectionsHelper.buildListFrom("samu(i)")),
    KALT_KUEHLEN_KALT_WERDEN("\u51b7", "kalt, k\u00fchlen, kalt werden, kaltes Wasser, kalter Sake", "\u51b7\u305f\u3044", "\u304a\u304f", 851, 192, CollectionsHelper.buildListFrom("REI"), CollectionsHelper.buildListFrom("tsume(tai)", "hi(yasu)", "sa(masu)", "hi(eru)", "sa(meru)", "hi(ya)", "hi(yakasu)")),
    WARM_WARM_WERDEN_SICH_ERWAERMEN__WETTER__("\u6696", "warm, erw\u00e4rmen, aufw\u00e4rmen, warm werden, sich erw\u00e4rmen, (warmes Wetter)", "\u6696\u304b\u3044", "\u3042\u305f\u305f\u304b\u3044", 645, 163, CollectionsHelper.buildListFrom("DAN"), CollectionsHelper.buildListFrom("atata(kai)", "atata(ka)", "atata(meru)", "atata(maru)")),
    WARM_WARM_WERDEN_SICH_ERWAERMEN__ANFASSEN__("\u6e29", "warm, erw\u00e4rmen, aufw\u00e4rmen, warm werden, sich erw\u00e4rmen, (warm beim Anfassen)", "\u6e29\u304b\u3044", "\u3042\u305f\u305f\u304b\u3044", 644, 162, CollectionsHelper.buildListFrom("ON"), CollectionsHelper.buildListFrom("atata(kai)", "atata(ka)", "atata(meru)", "atata(maru)")),
    KUEHL_FRISCH_ERFRISCHEND("\u6dbc", "k\u00fchl, angenehm k\u00fchl, frisch, erfrischend, sich drau\u00dfen erfrischen, frische Luft sch\u00f6pfen", "\u6dbc\u3057\u3044", "\u3059\u305a\u3057\u3044", 1267, 251, CollectionsHelper.buildListFrom("RYOU"), CollectionsHelper.buildListFrom("suzu(shii)", "suzu(mu)")),
    SCHLECHT_SCHLIMM_BOESE("\u60aa", "schlecht, schlimm, b\u00f6se", "\u60aa\u3044", "\u308f\u308b\u3044", 304, 114, CollectionsHelper.buildListFrom("AKU", "O"), CollectionsHelper.buildListFrom("waru(i)")),
    PFERD("\u99ac", "Pferd", "\u99ac", "\u3046\u307e", 283, 111, CollectionsHelper.buildListFrom("BA"), CollectionsHelper.buildListFrom("uma", "[ma]")),
    VOGEL("\u9ce5", "Vogel", "\u9ce5", "\u3068\u308a", 285, 111, CollectionsHelper.buildListFrom("CHOU"), CollectionsHelper.buildListFrom("tori")),
    RIND_KUH("\u725b", "Rind, Kuh", "\u725b", "\u3046\u3057", 281, 111, CollectionsHelper.buildListFrom("GYUU"), CollectionsHelper.buildListFrom("ushi")),
    SCHWEIN_HAUSSCHWEIN("\u8c5a", "Schwein, Hausschwein", "\u8c5a", "\u3076\u305f", 810, 186, CollectionsHelper.buildListFrom("TON"), CollectionsHelper.buildListFrom("buta")),
    BEWEGUNG_SICH_BEWEGEN("\u52d5", "Bewegung, sich bewegen, bewegen", "\u52d5\u7269", "\u3069\u3046\u3076\u3064", 231, 103, CollectionsHelper.buildListFrom("DOU"), CollectionsHelper.buildListFrom("ugo(ku)", "ugo(kasu)")),
    DING_SACHE_GEGENSTAND("\u7269", "Ding, Sache, Gegenstand", "\u52d5\u7269", "\u3069\u3046\u3076\u3064", 79, 82, CollectionsHelper.buildListFrom("BUTSU", "MOTSU"), CollectionsHelper.buildListFrom("mono")),
    MUSIK_BEQUEMLICHKEIT_ERFREULICH("\u697d", "Musik, Bequemlichkeit, sich freuen, genie\u00dfen, froh, erfreulich", "\u697d\u3057\u3044", "\u305f\u306e\u3057\u3044", 359, 122, CollectionsHelper.buildListFrom("GAKU", "RAKU"), CollectionsHelper.buildListFrom("tano(shimu)", "tano(shii)")),
    SCHWIERIG("\u96e3", "schwierig", "\u96e3\u3057\u3044", "\u3080\u305a\u304b\u3057\u3044", 566, 151, CollectionsHelper.buildListFrom("NAN"), CollectionsHelper.buildListFrom("muzuka(shii)", "kata(i)")),
    BEQUEMLICHKEIT_EXKREMENTE_POST("\u4fbf", "Bequemlichkeit, Exkremente, Gelegenheit, Post, Nachricht, Brief", "\u4fbf\u5229", "\u3079\u3093\u308a", 330, 118, CollectionsHelper.buildListFrom("BEN", "BIN"), CollectionsHelper.buildListFrom("tayo(ri)")),
    VORTEIL_ZINS_WIRKEN("\u5229", "Vorteil, Zins, wirksam sein, wirken", "\u4fbf\u5229", "\u3079\u3093\u308a", 329, 117, CollectionsHelper.buildListFrom("RI"), CollectionsHelper.buildListFrom("ki(ku)")),
    UN_NICHT("\u4e0d", "un-, nicht", "\u4e0d\u4fbf", "\u3075\u3079\u3093", 94, 84, CollectionsHelper.buildListFrom("FU", "BU"), CollectionsHelper.buildListFrom(new String[0])),
    WACHE_DIENST_NUMMER("\u756a", "Wache, Aufsicht, Dienst, Reihe, Nummer", "\u756a\u53f7", "\u3070\u3093\u3054\u3046", 185, 97, CollectionsHelper.buildListFrom("BAN"), CollectionsHelper.buildListFrom(new String[0])),
    NUMMER_PSEUDONYM("\u53f7", "Nummer, Pseudonym, verzweifeltes Schreien", "\u756a\u53f7", "\u3070\u3093\u3054\u3046", 266, 108, CollectionsHelper.buildListFrom("GOU"), CollectionsHelper.buildListFrom(new String[0])),
    BENUTZUNG_BOTE_BENUTZEN("\u4f7f", "Benutzung, Bote, benutzen", "\u4f7f\u3046", "\u3064\u304b\u3046", 331, 118, CollectionsHelper.buildListFrom("SHI"), CollectionsHelper.buildListFrom("tsuka(u)")),
    SELBST("\u81ea", "selbst", "\u81ea\u8ee2\u8eca", "\u3058\u3066\u3093\u3057\u3083", 62, 79, CollectionsHelper.buildListFrom("JI", "SHI"), CollectionsHelper.buildListFrom("mizuka(ra)")),
    ROLLEN_FALLEN_WAELZEN("\u8ee2", "rollen, fallen, w\u00e4lzen, hinfallen, umwerfen", "\u81ea\u8ee2\u8eca", "\u3058\u3066\u3093\u3057\u3083", 439, 133, CollectionsHelper.buildListFrom("TEN"), CollectionsHelper.buildListFrom("koro(bu)", "koro(garu)", "koro(geru)", "koro(gasu)")),
    SCHWERT_MESSER("\u5200", "Schwert, Messer", "\u5200", "\u304b\u305f\u306a", 37, 76, CollectionsHelper.buildListFrom("TOU"), CollectionsHelper.buildListFrom("katana")),
    VATER("\u7236", "Vater", "\u7236", "\u3061\u3061", 113, 87, CollectionsHelper.buildListFrom("FU"), CollectionsHelper.buildListFrom("chichi")),
    MUTTER("\u6bcd", "Mutter", "\u6bcd", "\u306f\u306f", 112, 86, CollectionsHelper.buildListFrom("BO"), CollectionsHelper.buildListFrom("haha")),
    GROSS_STARK_STATUR_GROESSE("\u4e08", "gro\u00df, stark, Statur, Gr\u00f6\u00dfe", "\u5927\u4e08\u592b", "\u3060\u3044\u3058\u3087\u3046\u3076", 1408, 272, CollectionsHelper.buildListFrom("JOU"), CollectionsHelper.buildListFrom("take")),
    EHEMANN_MANN("\u592b", "Ehemann, Mann", "\u5927\u4e08\u592b", "\u3060\u3044\u3058\u3087\u3046\u3076", 315, 115, CollectionsHelper.buildListFrom("FU", "[FUU]"), CollectionsHelper.buildListFrom("otto")),
    BITTEN_BETEN_WUENSCHEN("\u9858", "bitten, beten, w\u00fcnschen", "\u304a\u9858\u3044\u3057\u307e\u3059", "\u304a\u9858\u3044\u3057\u307e\u3059", 590, 155, CollectionsHelper.buildListFrom("GAN"), CollectionsHelper.buildListFrom("nega(u)")),
    ORT_STELLE("\u6240", "Ort, Stelle", "\u6240", "\u3068\u3053\u308d", 153, 92, CollectionsHelper.buildListFrom("SHO"), CollectionsHelper.buildListFrom("tokoro")),
    STRASSE_WEG_PFAD("\u9053", "Stra\u00dfe, Weg, Pfad, Dao/Tao", "\u9053", "\u307f\u3061", 149, 92, CollectionsHelper.buildListFrom("DOU", "[TOU]"), CollectionsHelper.buildListFrom("michi")),
    ZURUECKKEHREN("\u5e30", "zur\u00fcckkehren, nach Hause schicken", "\u5e30\u308b", "\u304b\u3048\u308b", 317, 116, CollectionsHelper.buildListFrom("KI"), CollectionsHelper.buildListFrom("kae(ru)", "kae(su)")),
    BAUEN_ERRICHTEN("\u5efa", "bauen, errichten, errichtet werden", "\u5efa\u7269", "\u305f\u3066\u3082\u306e", 913, 201, CollectionsHelper.buildListFrom("KEN", "[KON]"), CollectionsHelper.buildListFrom("ta(teru)", "ta(tsu)")),
    STOCKWERK_ETAGE_EBENE("\u968e", "Stockwerk, Etage, Ebene", "\u968e", "\u304b\u3044", 597, 156, CollectionsHelper.buildListFrom("KAI"), CollectionsHelper.buildListFrom(new String[0])),
    ERDE_LAND("\u5730", "Erde, Land", "\u5730\u4e0b", "\u3061\u304b", 118, 87, CollectionsHelper.buildListFrom("CHI", "JI"), CollectionsHelper.buildListFrom(new String[0])),
    BLATT_LAUB("\u8449", "Blatt, Laub", "\u8a00\u8449", "\u3053\u3068\u3070", 253, 107, CollectionsHelper.buildListFrom("YOU"), CollectionsHelper.buildListFrom("ha")),
    GLAENZEND_BEGABT_ENGLAND("\u82f1", "gl\u00e4nzend, brillant, begabt, England", "\u82f1\u8a9e", "\u3048\u3044\u3054", 354, 121, CollectionsHelper.buildListFrom("EI"), CollectionsHelper.buildListFrom(new String[0])),
    QUALITAET_NATUR_PFAD("\u8cea", "Qualit\u00e4t, Natur, Pfad", "\u8cea\u554f", "\u3057\u3064\u3082\u3093", 176, 96, CollectionsHelper.buildListFrom("SHITSU", "SHICHI", "[CHI]"), CollectionsHelper.buildListFrom(new String[0])),
    FRAGE_PROBLEM_FRAGEN("\u554f", "Frage, Problem, fragen, sich k\u00fcmmern (um)", "\u8cea\u554f", "\u3057\u3064\u3082\u3093", 162, 94, CollectionsHelper.buildListFrom("MON"), CollectionsHelper.buildListFrom("to(i)", "[tou]", "to(u)")),
    ANTWORT_ANTWORTEN("\u7b54", "Antwort, antworten", "\u7b54\u3048", "\u3053\u305f\u3048", 160, 93, CollectionsHelper.buildListFrom("TOU"), CollectionsHelper.buildListFrom("kota(e)", "kota(eru)")),
    ER_JENER("\u5f7c", "er, jener", "\u5f7c", "\u304b\u308c", 1010, 215, CollectionsHelper.buildListFrom("HI"), CollectionsHelper.buildListFrom("kare", "[kano]")),
    FARBE_EROTIK("\u8272", "Farbe, Erotik", "\u8272", "\u3044\u308d", 204, 100, CollectionsHelper.buildListFrom("SHOKU", "SHIKI"), CollectionsHelper.buildListFrom("iro")),
    KANJI_WIEDERHOLUNGSZEICHEN("\u3005", "Wiederholungszeichen, Kanji Wiederholungszeichen", "\u3005", "\u3005", 0, 0, CollectionsHelper.buildListFrom(new String[0]), CollectionsHelper.buildListFrom(new String[0])),
    FRUEHLING("\u6625", "Fr\u00fchling, Fr\u00fchjahr", "\u6625", "\u306f\u308b", 468, 137, CollectionsHelper.buildListFrom("SHUN"), CollectionsHelper.buildListFrom("haru")),
    HERBST("\u79cb", "Herbst", "\u79cb", "\u3042\u304d", 470, 138, CollectionsHelper.buildListFrom("SHUU"), CollectionsHelper.buildListFrom("aki")),
    WINTER("\u51ac", "Winter", "\u51ac", "\u3075\u3086", 467, 137, CollectionsHelper.buildListFrom("TOU"), CollectionsHelper.buildListFrom("fuyu")),
    BILD("\u7d75", "Bild", "\u7d75", "\u3048", 345, 120, CollectionsHelper.buildListFrom("KAI", "E"), CollectionsHelper.buildListFrom(new String[0])),
    ZWISCHENRAUM("\u9593", "Zwischenraum, Zeitraum, Raum, Zimmer", "\u9593", "\u3042\u3044\u3060", 43, 77, CollectionsHelper.buildListFrom("KAN", "KEN"), CollectionsHelper.buildListFrom("aida")),
    GESICHT("\u9854", "Gesicht", "\u9854", "\u304b\u304a", 277, 110, CollectionsHelper.buildListFrom("GAN"), CollectionsHelper.buildListFrom("kao")),
    DAMPF("\u6c7d", "Dampf", "\u6c7d\u8eca", "\u304d\u3057\u3083", 135, 90, CollectionsHelper.buildListFrom("KI"), CollectionsHelper.buildListFrom(new String[0])),
    VERGANGEN_GESTERN("\u6628", "vergangen, letzt, gestern", "\u6628\u65e5", "\u304d\u306e\u3046", 362, 122, CollectionsHelper.buildListFrom("SAKU"), CollectionsHelper.buildListFrom(new String[0])),
    SCHMERZ_LEID_BITTER("\u82e6", "Schmerz, Leid, leiden, qu\u00e4len, schmerzhaft, bitter", "\u82e6", "\u306b\u304c\u3044", 554, 150, CollectionsHelper.buildListFrom("KU"), CollectionsHelper.buildListFrom("kuru(shimu)", "kuru(shimeru)", "kuru(shii)", "niga(i)", "niga(ru)")),
    KLAR_AUFKLAREN_AUFKLAEREN("\u6674", "klar, aufklaren, kl\u00e4ren, aufkl\u00e4ren", "\u6674\u308c", "\u306f\u308c", 673, 167, CollectionsHelper.buildListFrom("SEI"), CollectionsHelper.buildListFrom("ha(re)", "ha(reru)", "ha(rasu)")),
    WEIT_AUSDEHNEN("\u5e83", "breit, weit, ausdehnen, erweitern, sich ausdehnen, verbreiten, sich verbreiten", "\u5e83\u3044", "\u3072\u308d\u3044", 707, 171, CollectionsHelper.buildListFrom("KOU"), CollectionsHelper.buildListFrom("hiro(i)", "hiro(geru)", "hiro(garu)", "hiro(meru)", "hiro(maru)")),
    SICH_BEW\u00d6LKEN("\u66c7", "sich bew\u00f6lken, sich tr\u00fcben", "\u66c7\u308b", "\u304f\u3082\u308b", 647, 163, CollectionsHelper.buildListFrom("DON"), CollectionsHelper.buildListFrom("kumo(ru)")),
    STERN("\u661f", "Stern", "\u661f", "\u307b\u3057", 743, 177, CollectionsHelper.buildListFrom("SEI", "[SHOU]"), CollectionsHelper.buildListFrom("hoshi"));

    private final String character;
    private final String germanMeaning;
    private final String normalKanjiHiraganaWord;
    private final String normalHiraganaWord;
    private final int numberInKanjiAndKanaBook;
    private final int pageNumberInKanjiAndKanaBook;
    private final List<String> onLesungen;
    private final List<String> kunLesungen;

    private Kanji(String string2, String string3, String string4, String string5, int n2, int n3, List<String> list, List<String> list2) {
        this.character = string2;
        this.germanMeaning = string3;
        this.normalKanjiHiraganaWord = string4;
        this.normalHiraganaWord = string5;
        this.numberInKanjiAndKanaBook = n2;
        this.pageNumberInKanjiAndKanaBook = n3;
        this.onLesungen = list;
        this.kunLesungen = list2;
    }

    public String getCharacter() {
        return this.character;
    }

    public String getGermanMeaning() {
        return this.germanMeaning;
    }

    public String getNormalKanjiHiraganaWord() {
        return this.normalKanjiHiraganaWord;
    }

    public String getNormalHiraganaWord() {
        return this.normalHiraganaWord;
    }

    public int getNumberInKanjiAndKanaBook() {
        return this.numberInKanjiAndKanaBook;
    }

    public int getPageNumberInKanjiAndKanaBook() {
        return this.pageNumberInKanjiAndKanaBook;
    }

    public List<String> getOnLesungen() {
        return this.onLesungen;
    }

    public List<String> getKunLesungen() {
        return this.kunLesungen;
    }

    public static List<Kanji> getAllKanjiAsList() {
        return CollectionsHelper.arrayToList(Kanji.values());
    }

    public static List<String> getAllKanjiAsStringList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Kanji kanji : Kanji.values()) {
            arrayList.add(kanji.getCharacter());
        }
        return arrayList;
    }

    public static boolean containsKanji(String string) {
        return Text.contains(string, Kanji.getAllKanjiAsStringList());
    }

    public static boolean containsOnlyKanji(String string) {
        if (string.isEmpty()) {
            return false;
        }
        List<String> list = Kanji.getAllKanjiAsStringList();
        for (String string2 : Text.textToCharactersList(string)) {
            if (list.contains(string2)) continue;
            return false;
        }
        return true;
    }

    public static int firstIndexOfKanji(String string) {
        List<String> list = Kanji.getAllKanjiAsStringList();
        List<String> list2 = Text.textToCharactersList(string);
        for (int i = 0; i < list2.size(); ++i) {
            String string2 = list2.get(i);
            if (!list.contains(string2)) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOfKanji(String string) {
        List<String> list = Kanji.getAllKanjiAsStringList();
        List<String> list2 = Text.textToCharactersList(string);
        for (int i = list2.size() - 1; i >= 0; --i) {
            String string2 = list2.get(i);
            if (!list.contains(string2)) continue;
            return i;
        }
        return -1;
    }

    public static int getNumberOfKnownKanji() {
        return Kanji.values().length;
    }

    public static Kanji getByCharacter(String string) {
        for (Kanji kanji : Kanji.values()) {
            if (!string.equals(kanji.getCharacter())) continue;
            return kanji;
        }
        throw new RuntimeException("Kein Kanji zum Zeichen '" + string + "' gefunden.");
    }

    public static List<Kanji> getAllKanjiFromText(String string) {
        ArrayList<Kanji> arrayList = new ArrayList<Kanji>();
        for (String string2 : Text.textToCharactersList(string)) {
            for (Kanji kanji : Kanji.values()) {
                String string3 = kanji.getCharacter();
                if (!string2.equals(string3)) continue;
                arrayList.add(kanji);
            }
        }
        return arrayList;
    }
}

