/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.grammar.table;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.grammar.AdjectivePositivePresenceFinder;
import de.duehl.vocabulary.japanese.grammar.VerbWoerterbuchformFinder;
import de.duehl.vocabulary.japanese.grammar.find.RelatedVocablesFinder;
import de.duehl.vocabulary.japanese.grammar.table.data.GrammarTableType;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.subdialogs.GrammarTableBaseFormUserSelectionDialog;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.subdialogs.GrammarTableBaseFormUserSortDialog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

class GrammarTableRowCreator {
    public static final Vocable NOT_FOUND_FORM = new Vocable().setKanji("NICHT GEFUNDENE WORTFORM");
    private final List<Vocabulary> vocabularies;
    private final OwnList ownList;
    private final GrammarTableType grammarTableType;
    private final List<String> searchWords;
    private final FumikoUiObjects uiObjects;
    private final boolean searchForBaseForms;
    private List<List<Vocable>> listOfVocablesInRow;
    private boolean created;
    private List<Vocable> baseFormVocables;
    private boolean notAppliedDialog;

    public GrammarTableRowCreator(FumikoDataStructures fumikoDataStructures, OwnList ownList, GrammarTableType grammarTableType, List<String> list, FumikoUiObjects fumikoUiObjects) {
        this.ownList = ownList;
        this.grammarTableType = grammarTableType;
        this.searchWords = list;
        this.uiObjects = fumikoUiObjects;
        this.vocabularies = fumikoDataStructures.getVocabularies();
        Options options = fumikoDataStructures.getOptions();
        this.searchForBaseForms = options.isGrammarTableSearchForBaseForms();
    }

    public void create() {
        this.created = false;
        this.notAppliedDialog = false;
        this.determineBaseFormVocablesFromOwnList();
        if (this.baseFormVocables.isEmpty()) {
            this.informEmtpy("Ermittlung der entsprechenden Vokabeln in Grundform aus der Liste");
        } else {
            this.makeBaseFormsDiscjunctAndSortThem();
            this.letUserSelectWantedBaseForms();
            if (this.baseFormVocables.isEmpty()) {
                this.informEmtpy("nach Auswahl der Grundformen durch Sie");
            } else {
                this.letUserSortWantedBaseForms();
                if (this.baseFormVocables.isEmpty()) {
                    this.informEmtpy("nach Sortierung der Grundformen durch Sie");
                } else {
                    this.searchWantedVocableForms();
                    this.created = true;
                }
            }
        }
    }

    private void determineBaseFormVocablesFromOwnList() {
        List<Vocable> list = this.determineVerbsOrAdjectivesFromOwnList();
        this.baseFormVocables = this.determineBaseForms(list);
        if (this.searchForBaseForms) {
            ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
            arrayList.addAll(list);
            arrayList.removeAll(this.baseFormVocables);
            List<Vocable> list2 = this.createBaseFormVocablesFromNotBaseFormVocables(arrayList);
            this.baseFormVocables.addAll(list2);
        }
    }

    private List<Vocable> determineVerbsOrAdjectivesFromOwnList() {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocable vocable : this.ownList.getVocables()) {
            List<String> list = vocable.getPartsOfSpeech();
            if (!this.containsPartsOfSpeachOneOfTheRightForms(list)) continue;
            arrayList.add(vocable);
        }
        return arrayList;
    }

    private boolean containsPartsOfSpeachOneOfTheRightForms(List<String> list) {
        switch (this.grammarTableType) {
            case VERB: {
                return list.contains("Verb");
            }
            case I_ADJEKTIV: 
            case NA_ADJEKTIV: {
                return list.contains("Adjektiv");
            }
        }
        throw new RuntimeException("Unbekanne Tabellenart " + this.grammarTableType);
    }

    private List<Vocable> determineBaseForms(List<Vocable> list) {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocable vocable : list) {
            if (!this.hasVocableBaseForm(vocable)) continue;
            arrayList.add(vocable);
        }
        return arrayList;
    }

    private boolean hasVocableBaseForm(Vocable vocable) {
        switch (this.grammarTableType) {
            case VERB: {
                return vocable.isVerbInWoerterbuchform();
            }
            case I_ADJEKTIV: {
                return vocable.isIAdjectivInPositivePresence();
            }
            case NA_ADJEKTIV: {
                return vocable.isNaAdjectivInPositivePresence();
            }
        }
        throw new RuntimeException("Unbekanne Tabellenart " + this.grammarTableType);
    }

    private List<Vocable> createBaseFormVocablesFromNotBaseFormVocables(List<Vocable> list) {
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        block4: for (Vocable vocable : list) {
            switch (this.grammarTableType) {
                case VERB: {
                    Vocable vocable2 = VerbWoerterbuchformFinder.determineWoerterbuchform(vocable, this.vocabularies);
                    if (!vocable2.equals(VerbWoerterbuchformFinder.NO_WOERTERBUCHFORM_FOUND)) {
                        arrayList.add(vocable2);
                    }
                }
                case I_ADJEKTIV: 
                case NA_ADJEKTIV: {
                    Vocable vocable3 = AdjectivePositivePresenceFinder.determinePositivePresence(vocable, this.vocabularies);
                    if (vocable3.equals(AdjectivePositivePresenceFinder.NO_POSITIVE_PRESENCE_FOUND)) continue block4;
                    arrayList.add(vocable3);
                    continue block4;
                }
            }
            throw new RuntimeException("Unbekanne Tabellenart " + this.grammarTableType);
        }
        return arrayList;
    }

    private void sortBaseForms(List<Vocable> list) {
        Collections.sort(list, new Comparator<Vocable>(){

            @Override
            public int compare(Vocable vocable, Vocable vocable2) {
                String string = vocable.getKana();
                String string2 = vocable2.getKana();
                return string.compareTo(string2);
            }
        });
    }

    private void makeBaseFormsDiscjunctAndSortThem() {
        this.baseFormVocables = CollectionsHelper.createDisjunctList(this.baseFormVocables);
        this.sortBaseForms(this.baseFormVocables);
    }

    private void letUserSelectWantedBaseForms() {
        GrammarTableBaseFormUserSelectionDialog grammarTableBaseFormUserSelectionDialog = new GrammarTableBaseFormUserSelectionDialog(this.baseFormVocables, this.uiObjects);
        grammarTableBaseFormUserSelectionDialog.setVisible(true);
        if (!grammarTableBaseFormUserSelectionDialog.isApplied()) {
            this.notAppliedDialog = true;
            this.baseFormVocables.clear();
        }
    }

    private void letUserSortWantedBaseForms() {
        GrammarTableBaseFormUserSortDialog grammarTableBaseFormUserSortDialog = new GrammarTableBaseFormUserSortDialog(this.baseFormVocables, this.uiObjects);
        grammarTableBaseFormUserSortDialog.setVisible(true);
        if (!grammarTableBaseFormUserSortDialog.isApplied()) {
            this.notAppliedDialog = true;
            this.baseFormVocables.clear();
        }
    }

    private void searchWantedVocableForms() {
        this.listOfVocablesInRow = new ArrayList<List<Vocable>>();
        for (Vocable vocable : this.baseFormVocables) {
            List<Vocable> list = this.buildWantedForms(vocable);
            this.listOfVocablesInRow.add(list);
        }
    }

    private List<Vocable> buildWantedForms(Vocable vocable2) {
        RelatedVocablesFinder relatedVocablesFinder = new RelatedVocablesFinder(this.vocabularies, vocable2, vocable -> this.isVocableRelated(vocable));
        relatedVocablesFinder.find();
        List<Vocable> list = relatedVocablesFinder.getRelatedVocables();
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (String string : this.searchWords) {
            boolean bl = false;
            for (Vocable vocable3 : list) {
                List<String> list2 = vocable3.getSearchWords();
                if (!list2.contains(string)) continue;
                arrayList.add(vocable3);
                bl = true;
                break;
            }
            if (bl) continue;
            arrayList.add(NOT_FOUND_FORM);
        }
        return arrayList;
    }

    private boolean isVocableRelated(Vocable vocable) {
        switch (this.grammarTableType) {
            case VERB: {
                return vocable.isVerb();
            }
            case I_ADJEKTIV: {
                return vocable.isIAdjective();
            }
            case NA_ADJEKTIV: {
                return vocable.isNaAdjective();
            }
        }
        throw new RuntimeException("Unbekanne Tabellenart " + this.grammarTableType);
    }

    private void informEmtpy(String string) {
        if (!this.notAppliedDialog) {
            String string2 = "Es liegen nach " + string + " keine Vokabeln in Grundform vor, aus denen die Tabelle erstellt werden k\u00f6nnte";
            GuiTools.informUser("Keine Tabellen-Erzeugung m\u00f6glich", Text.addLineBreaks(string2, 60));
        }
    }

    public boolean isCreated() {
        return this.created;
    }

    public List<List<Vocable>> getListOfVocablesInRow() {
        return this.listOfVocablesInRow;
    }
}

