/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.symbol.kana.html;

import de.duehl.basics.text.html.generation.HtmlBuilder;
import de.duehl.vocabulary.japanese.data.symbol.Kana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.html.data.KanaStructure;

public class KanaHtmlCreator {
    private static final String HTML_STYLE = "body {\n    font-size:14pt;\n    background-color:white;\n    color:black;\n}\np {\n    background-color:white;\n    color:black;\n}\ntable {\n    border: 1px solid;\n}\nth {\n    background-color:#DDD;\n    border: 1px solid;\n    margin:3px;\n    padding:5px;\n}\ntd {\n    border: 1px solid;\n    margin:3px;\n    padding:5px;\n}\n.pronunciationChangedCell {\n    background-color:#FFFFE6;\n}\n.exceptionCell {\n    background-color:#FFE6E6;\n}\n.emptyCell, td.emptyCell {\n    border: 0px solid;\n}\n";
    private final KanaStructure structure;
    private final String kanaName;
    private HtmlBuilder html;

    public KanaHtmlCreator(KanaStructure kanaStructure, String string) {
        this.structure = kanaStructure;
        this.kanaName = string;
    }

    public void create() {
        this.init();
        this.appendPageHead();
        this.appendMainTable();
        this.appendLehnwortTable();
        this.appendOtherKanaPart();
        this.appendLegend();
        this.appendFoot();
    }

    private void init() {
        this.html = new HtmlBuilder();
        this.html.appendHtml5HeadWithOwnExtendedCss(this.kanaName, HTML_STYLE);
    }

    private void appendPageHead() {
        this.html.append("<p style=\"font-size:28pt;\">" + this.kanaName + " Tabelle</p>");
    }

    private void appendMainTable() {
        this.html.appendOpeningTable();
        this.appendMainTableHeadRow();
        this.appendMainTableARow();
        this.appendMainTableIRow();
        this.appendMainTableURow();
        this.appendMainTableERow();
        this.appendMainTableORow();
        this.appendSpaceRow();
        this.appendMainTableYaRow();
        this.appendMainTableYuRow();
        this.appendMainTableYoRow();
        this.html.appendClosingTable();
    }

    private void appendMainTableHeadRow() {
        this.html.appendOpeningTr();
        this.html.appendTh("p");
        this.html.appendTh("b");
        this.html.appendTh("d");
        this.html.appendTh("z");
        this.html.appendTh("g");
        this.html.appendTh("");
        this.html.appendTh("w");
        this.html.appendTh("r");
        this.html.appendTh("y");
        this.html.appendTh("m");
        this.html.appendTh("h");
        this.html.appendTh("n");
        this.html.appendTh("t");
        this.html.appendTh("s");
        this.html.appendTh("k");
        this.html.appendTh("");
        this.html.appendTh("");
        this.html.appendClosingTr();
    }

    private void appendMainTableARow() {
        this.html.appendOpeningTr();
        this.html.appendTd(this.createKanaCell(this.structure.getKanaPaPiPuPePo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaBaBiBuBeBo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaDaJiZuDeDo().get(0)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaZaJiZuZeZo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaGaGiGuGeGo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaN()));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaWaWo().get(0)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaRaRiRuReRo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaYaYuYo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaMaMiMuMeMo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaHaHiFuHeHo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaNaNiNuNeNo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaTaChiTsuTeTo().get(0)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaSaShiSuSeSo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaKaKiKuKeKo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaAIUEO().get(0)));
        this.html.appendTh("a");
        this.html.appendClosingTr();
    }

    private void appendMainTableIRow() {
        this.html.appendOpeningTr();
        this.html.appendTd(this.createKanaCell(this.structure.getKanaPaPiPuPePo().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaBaBiBuBeBo().get(1)));
        this.html.appendTd(this.createExceptionKanaCell(this.structure.getKanaDaJiZuDeDo().get(1)));
        this.html.appendTd(this.createExceptionKanaCell(this.structure.getKanaZaJiZuZeZo().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaGaGiGuGeGo().get(1)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaRaRiRuReRo().get(1)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createKanaCell(this.structure.getKanaMaMiMuMeMo().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaHaHiFuHeHo().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaNaNiNuNeNo().get(1)));
        this.html.appendTd(this.createExceptionKanaCell(this.structure.getKanaTaChiTsuTeTo().get(1)));
        this.html.appendTd(this.createExceptionKanaCell(this.structure.getKanaSaShiSuSeSo().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaKaKiKuKeKo().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaAIUEO().get(1)));
        this.html.appendTh("i");
        this.html.appendClosingTr();
    }

    private void appendMainTableURow() {
        this.html.appendOpeningTr();
        this.html.appendTd(this.createKanaCell(this.structure.getKanaPaPiPuPePo().get(2)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaBaBiBuBeBo().get(2)));
        this.html.appendTd(this.createExceptionKanaCell(this.structure.getKanaDaJiZuDeDo().get(2)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaZaJiZuZeZo().get(2)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaGaGiGuGeGo().get(2)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaRaRiRuReRo().get(2)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaYaYuYo().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaMaMiMuMeMo().get(2)));
        this.html.appendTd(this.createExceptionKanaCell(this.structure.getKanaHaHiFuHeHo().get(2)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaNaNiNuNeNo().get(2)));
        this.html.appendTd(this.createExceptionKanaCell(this.structure.getKanaTaChiTsuTeTo().get(2)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaSaShiSuSeSo().get(2)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaKaKiKuKeKo().get(2)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaAIUEO().get(2)));
        this.html.appendTh("u");
        this.html.appendClosingTr();
    }

    private void appendMainTableERow() {
        this.html.appendOpeningTr();
        this.html.appendTd(this.createKanaCell(this.structure.getKanaPaPiPuPePo().get(3)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaBaBiBuBeBo().get(3)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaDaJiZuDeDo().get(3)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaZaJiZuZeZo().get(3)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaGaGiGuGeGo().get(3)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaRaRiRuReRo().get(3)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createKanaCell(this.structure.getKanaMaMiMuMeMo().get(3)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaHaHiFuHeHo().get(3)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaNaNiNuNeNo().get(3)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaTaChiTsuTeTo().get(3)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaSaShiSuSeSo().get(3)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaKaKiKuKeKo().get(3)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaAIUEO().get(3)));
        this.html.appendTh("e");
        this.html.appendClosingTr();
    }

    private void appendMainTableORow() {
        this.html.appendOpeningTr();
        this.html.appendTd(this.createKanaCell(this.structure.getKanaPaPiPuPePo().get(4)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaBaBiBuBeBo().get(4)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaDaJiZuDeDo().get(4)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaZaJiZuZeZo().get(4)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaGaGiGuGeGo().get(4)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createKanaCell(this.structure.getKanaWaWo().get(1)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaRaRiRuReRo().get(4)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaYaYuYo().get(2)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaMaMiMuMeMo().get(4)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaHaHiFuHeHo().get(4)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaNaNiNuNeNo().get(4)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaTaChiTsuTeTo().get(4)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaSaShiSuSeSo().get(4)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaKaKiKuKeKo().get(4)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaAIUEO().get(4)));
        this.html.appendTh("o");
        this.html.appendClosingTr();
    }

    private void appendSpaceRow() {
        this.html.appendOpeningTr();
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTh("");
        this.html.appendClosingTr();
    }

    private void appendMainTableYaRow() {
        this.html.appendOpeningTr();
        this.html.appendTd(this.createKanaCell(this.structure.getKanaPyaPyuPyo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaByaByuByo().get(0)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaJaJuJo2().get(0)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaJaJuJo1().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaGyaGyuGyo().get(0)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaRyaRyuRyo().get(0)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createKanaCell(this.structure.getKanaMyaMyuMyo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaHyaHyuHyo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaNyaNyuNyo().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaChaChuCho().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaShaShuSho().get(0)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaKyaKyuKyo().get(0)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTh("ya");
        this.html.appendClosingTr();
    }

    private void appendMainTableYuRow() {
        this.html.appendOpeningTr();
        this.html.appendTd(this.createKanaCell(this.structure.getKanaPyaPyuPyo().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaByaByuByo().get(1)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaJaJuJo2().get(1)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaJaJuJo1().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaGyaGyuGyo().get(1)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaRyaRyuRyo().get(1)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createKanaCell(this.structure.getKanaMyaMyuMyo().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaHyaHyuHyo().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaNyaNyuNyo().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaChaChuCho().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaShaShuSho().get(1)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaKyaKyuKyo().get(1)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTh("yu");
        this.html.appendClosingTr();
    }

    private void appendMainTableYoRow() {
        this.html.appendOpeningTr();
        this.html.appendTd(this.createKanaCell(this.structure.getKanaPyaPyuPyo().get(2)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaByaByuByo().get(2)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaJaJuJo2().get(2)));
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaJaJuJo1().get(2)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaGyaGyuGyo().get(2)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createPronunciationChangedKanaCell(this.structure.getKanaRyaRyuRyo().get(2)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTd(this.createKanaCell(this.structure.getKanaMyaMyuMyo().get(2)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaHyaHyuHyo().get(2)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaNyaNyuNyo().get(2)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaChaChuCho().get(2)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaShaShuSho().get(2)));
        this.html.appendTd(this.createKanaCell(this.structure.getKanaKyaKyuKyo().get(2)));
        this.html.appendTd(this.createEmptyKanaCell());
        this.html.appendTh("yo");
        this.html.appendClosingTr();
    }

    private void appendLehnwortTable() {
        this.html.appendP("Zus\u00e4tzliche Kana f\u00fcr Lehnw\u00f6rter");
        this.html.appendOpeningTable();
        this.html.appendOpeningTr();
        for (Kana kana : this.structure.getKanaLehnworte()) {
            this.html.appendTd(this.createKanaCell(kana));
        }
        this.html.appendClosingTr();
        this.html.appendClosingTable();
    }

    private void appendOtherKanaPart() {
        this.html.appendP("Sonstige Zeichen");
        this.html.appendOpeningTable();
        this.html.appendOpeningTr();
        this.html.appendTd(this.createKanaCell(this.structure.getKanaKleinesTsu()));
        for (Kana kana : this.structure.getKanaKleinesYaYuYo()) {
            this.html.appendTd(this.createKanaCell(kana));
        }
        this.html.appendClosingTr();
        this.html.appendClosingTable();
    }

    private void appendLegend() {
        this.html.appendP("Legende");
        this.html.appendOpeningTable();
        this.html.appendOpeningTr();
        this.html.appendTd(this.createPronunciationChangedKanaCell(new Kana("Aussprache anders", "")));
        this.html.appendTd(this.createExceptionKanaCell(new Kana("Ausnahme", "")));
        this.html.appendClosingTr();
        this.html.appendClosingTable();
    }

    private String createKanaCell(Kana kana) {
        return this.createKanaCell(kana, "");
    }

    private String createPronunciationChangedKanaCell(Kana kana) {
        return this.createKanaCell(kana, "pronunciationChangedCell");
    }

    private String createExceptionKanaCell(Kana kana) {
        return this.createKanaCell(kana, "exceptionCell");
    }

    private String createEmptyKanaCell() {
        Kana kana = new Kana("", "");
        return this.createKanaCell(kana, "emptyCell");
    }

    private String createKanaCell(Kana kana, String string) {
        Object object = string.isBlank() ? "<p>" : "<p class=\"" + string + "\">";
        return "<center>" + (String)object + "<span style=\"font-size:18pt;\">" + kana.getCharacter() + "</span><br /><span style=\"font-size:12pt;\">" + kana.getHepburn() + "</span></p></center>";
    }

    private void appendFoot() {
        this.html.appendFoot();
    }

    public String getHtml() {
        return this.html.toString();
    }
}

