/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.symbol.kana.internal.io;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanaData;
import de.duehl.vocabulary.japanese.common.persistence.SessionManager;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.RealInternalKanaDataRequester;
import de.duehl.vocabulary.japanese.startup.ui.data.MessageAppender;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InternalKanaDataReader {
    public static final String INTERNAL_KANA_DATA_DIRECTORY = FileHelper.concatPathes(SessionManager.VOCABLE_TRAINER_DIRECTORY, "internal_kana_data");
    private static final String INTERNAL_KANA_DATA_EXTENSION = ".ikad";
    private final MessageAppender messageAppender;
    private Map<String, InternalAdditionalKanaData> key2InternalKanaDataMap;
    private RealInternalKanaDataRequester requester;
    private final List<String> warningLines;

    public InternalKanaDataReader(MessageAppender messageAppender) {
        this.messageAppender = messageAppender;
        this.warningLines = new ArrayList<String>();
    }

    public void read() {
        this.readInternalKanaData();
        this.checkForNewHiragana();
        this.checkForNewKatakana();
        this.checkForUnusedInternalKanaData();
        this.createRequester();
    }

    private void readInternalKanaData() {
        Object object;
        this.appendMessage("Lese interne benutzerabh\u00e4ngige Daten zu allen bekannten Kana ...");
        FileHelper.createDirectoryIfNotExists(INTERNAL_KANA_DATA_DIRECTORY);
        List<String> list = FileHelper.findFilesInMainDirectoryNio2WithExtensions(INTERNAL_KANA_DATA_DIRECTORY, INTERNAL_KANA_DATA_EXTENSION);
        this.appendMessage(NumberString.taupu(list.size()) + " interne Kana-Datens\u00e4tze gefunden.");
        this.appendMessage("Lese interne Kana-Datens\u00e4tze ein ...");
        ArrayList<InternalAdditionalKanaData> arrayList = new ArrayList<InternalAdditionalKanaData>();
        for (String object2 : list) {
            object = InternalAdditionalKanaData.load(object2);
            arrayList.add((InternalAdditionalKanaData)object);
        }
        this.appendMessage(NumberString.taupu(arrayList.size()) + " interne Kana-Datens\u00e4tze eingelesen.");
        this.key2InternalKanaDataMap = new HashMap<String, InternalAdditionalKanaData>();
        for (InternalAdditionalKanaData internalAdditionalKanaData : arrayList) {
            object = internalAdditionalKanaData.getKey();
            if (this.key2InternalKanaDataMap.containsKey(object)) {
                throw new RuntimeException("Der Schl\u00fcssel '" + (String)object + "' kommt mehrfach vor!");
            }
            this.key2InternalKanaDataMap.put((String)object, internalAdditionalKanaData);
        }
        this.appendMessage("Verzeichnis mit " + NumberString.taupu(this.key2InternalKanaDataMap.size()) + " Verweisen von Schl\u00fcssel auf interne Kana-Datens\u00e4tze aufgebaut.");
    }

    private void checkForNewHiragana() {
        int n = 0;
        for (Hiragana hiragana : Hiragana.values()) {
            String string = "HIRAGANA_" + hiragana.name();
            if (this.key2InternalKanaDataMap.containsKey(string)) continue;
            InternalAdditionalKanaData internalAdditionalKanaData = new InternalAdditionalKanaData();
            internalAdditionalKanaData.setKey(string);
            String string2 = FileHelper.concatPathes(INTERNAL_KANA_DATA_DIRECTORY, string + INTERNAL_KANA_DATA_EXTENSION);
            internalAdditionalKanaData.setFilename(string2);
            this.appendMessage("neu: " + string2);
            ++n;
            internalAdditionalKanaData.save();
            this.key2InternalKanaDataMap.put(string, internalAdditionalKanaData);
        }
        this.appendMessage(NumberString.taupu(n) + " neue interne Hiragana-Daten angelegt.");
    }

    private void checkForNewKatakana() {
        int n = 0;
        for (Katakana katakana : Katakana.values()) {
            String string = "KATAKANA_" + katakana.name();
            if (this.key2InternalKanaDataMap.containsKey(string)) continue;
            InternalAdditionalKanaData internalAdditionalKanaData = new InternalAdditionalKanaData();
            internalAdditionalKanaData.setKey(string);
            String string2 = FileHelper.concatPathes(INTERNAL_KANA_DATA_DIRECTORY, string + INTERNAL_KANA_DATA_EXTENSION);
            internalAdditionalKanaData.setFilename(string2);
            this.appendMessage("neu: " + string2);
            ++n;
            internalAdditionalKanaData.save();
            this.key2InternalKanaDataMap.put(string, internalAdditionalKanaData);
        }
        this.appendMessage(NumberString.taupu(n) + " neue interne Katakana-Daten angelegt.");
    }

    private void checkForUnusedInternalKanaData() {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.key2InternalKanaDataMap.keySet());
        for (Hiragana hiragana : Hiragana.values()) {
            string = "HIRAGANA_" + hiragana.name();
            if (!arrayList.contains(string)) continue;
            arrayList.remove(string);
        }
        for (Katakana katakana : Katakana.values()) {
            string = "KATAKANA_" + katakana.name();
            if (!arrayList.contains(string)) continue;
            arrayList.remove(string);
        }
        if (arrayList.isEmpty()) {
            this.appendMessage("Alle interne Daten zu Kana wurden einem Kana zugeordnet.");
        } else {
            String string2 = NumberString.germanPlural(arrayList.size(), "interne Daten", "internes Datum");
            String string3 = NumberString.germanPlural(arrayList.size(), "welche", "welches");
            this.warningLines.add("Es gibt " + NumberString.taupu(arrayList.size()) + " " + string2 + " zu Kana, " + string3 + " keinem Kana zugeordnet wurden:");
            for (String string4 : arrayList) {
                this.warningLines.add("    " + string4);
            }
            for (String string5 : this.warningLines) {
                this.appendMessage(string5);
            }
        }
    }

    private void createRequester() {
        this.requester = new RealInternalKanaDataRequester(this.key2InternalKanaDataMap);
    }

    private void appendMessage(String string) {
        this.messageAppender.appendMessage(string);
    }

    public RealInternalKanaDataRequester getRequester() {
        return this.requester;
    }

    public List<String> getWarningLines() {
        return this.warningLines;
    }
}

