/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.symbol.kana.test;

import de.duehl.math.stochastic.RandomSampleWithoutPutBack;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalKanaData;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import de.duehl.vocabulary.japanese.logic.symbol.kana.test.data.KatakanaForTestSelectionMethod;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kana.katakanatest.KatakanaTestParameterChooser;
import de.duehl.vocabulary.japanese.ui.dialog.kana.katakanatest.KatakanaTester;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KatakanaTesterLogic {
    private static final boolean DEBUG = false;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private boolean goAhead;
    private List<Katakana> katakanaList;
    private int numberOfKatakanaToTest;
    private boolean useOriginalKatakanaOrder;
    private List<Katakana> katakanaToTest;
    private KatakanaForTestSelectionMethod selectionMethod;
    private List<Katakana> notTenTimesGoodTestedKatakanaList;

    public KatakanaTesterLogic(FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects) {
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
    }

    public void test() {
        this.init();
        if (this.goAhead) {
            this.askTestParameters();
        }
        if (this.goAhead) {
            this.determineKatakanaToTest();
        }
        if (this.goAhead) {
            this.startRealTest();
        }
    }

    private void init() {
        this.goAhead = true;
        this.determineNotTenTimesGoodTestedKatakanaList();
    }

    private void determineNotTenTimesGoodTestedKatakanaList() {
        this.notTenTimesGoodTestedKatakanaList = new ArrayList<Katakana>();
        InternalKanaDataRequester internalKanaDataRequester = this.dataStructures.getInternalKanaDataRequester();
        for (Katakana katakana : Katakana.values()) {
            InternalAdditionalKanaData internalAdditionalKanaData = internalKanaDataRequester.getInternalDataForKatakana(katakana);
            if (internalAdditionalKanaData.getLastCorrectTestsCount() >= 10) continue;
            this.notTenTimesGoodTestedKatakanaList.add(katakana);
        }
    }

    private void askTestParameters() {
        KatakanaTestParameterChooser katakanaTestParameterChooser = new KatakanaTestParameterChooser(this.notTenTimesGoodTestedKatakanaList, this.uiObjects.getGuiLocation(), this.uiObjects.getProgramImage());
        katakanaTestParameterChooser.setVisible(true);
        if (katakanaTestParameterChooser.isApplied()) {
            this.katakanaList = katakanaTestParameterChooser.getKatakanaList();
            this.numberOfKatakanaToTest = katakanaTestParameterChooser.getNumberOfKatakanaToTest();
            this.useOriginalKatakanaOrder = katakanaTestParameterChooser.isUseOriginalKatakanaOrder();
            this.selectionMethod = katakanaTestParameterChooser.getSelectionMethod();
            if (this.katakanaList.isEmpty()) {
                String string = "Leer Menge an Katakana ausgew\u00e4hlt";
                String string2 = "Sie haben eine leere Menge an abzufragenden Katakana ausgew\u00e4hlt, daher ist nichts abzufragen.";
                GuiTools.informUser(string, string2);
                this.goAhead = false;
            }
        } else {
            this.goAhead = false;
        }
    }

    private void determineKatakanaToTest() {
        switch (this.selectionMethod) {
            case RANDOM_BY_NUMBER: {
                this.determineKatakanaToTestByRandomNumber();
                return;
            }
            case ALL: {
                this.useAllKatakana();
                return;
            }
            case LAST_N: {
                this.useLastNKatakana();
                return;
            }
            case NOT_TEN_TIMES_GOOD_TESTED: {
                this.useNotTenTimesGoodTestedKatakanaList();
                return;
            }
        }
        this.goAhead = false;
    }

    private void determineKatakanaToTestByRandomNumber() {
        List<Integer> list = this.createKatakanaPositionSample();
        this.fillKatakanaToTestWithKatakanaPositionSample(list);
    }

    private List<Integer> createKatakanaPositionSample() {
        int n = 1;
        int n2 = this.katakanaList.size();
        int n3 = Math.min(this.katakanaList.size(), this.numberOfKatakanaToTest);
        RandomSampleWithoutPutBack randomSampleWithoutPutBack = new RandomSampleWithoutPutBack(n, n2, n3);
        randomSampleWithoutPutBack.drawSample();
        List<Integer> list = randomSampleWithoutPutBack.getSample();
        if (this.useOriginalKatakanaOrder) {
            Collections.sort(list);
        }
        return list;
    }

    private void fillKatakanaToTestWithKatakanaPositionSample(List<Integer> list) {
        this.katakanaToTest = new ArrayList<Katakana>();
        for (int n : list) {
            int n2 = n - 1;
            Katakana katakana = this.katakanaList.get(n2);
            this.katakanaToTest.add(katakana);
        }
    }

    private void useAllKatakana() {
        this.katakanaToTest = new ArrayList<Katakana>();
        this.katakanaToTest.addAll(this.katakanaList);
        if (!this.useOriginalKatakanaOrder) {
            Collections.shuffle(this.katakanaToTest);
        }
    }

    private void useLastNKatakana() {
        int n;
        this.katakanaToTest = new ArrayList<Katakana>();
        int n2 = this.katakanaList.size();
        for (int i = n = Math.max(0, n2 - this.numberOfKatakanaToTest); i <= n2 - 1; ++i) {
            Katakana katakana = this.katakanaList.get(i);
            this.katakanaToTest.add(katakana);
        }
        if (!this.useOriginalKatakanaOrder) {
            Collections.shuffle(this.katakanaToTest);
        }
    }

    private void useNotTenTimesGoodTestedKatakanaList() {
        this.katakanaToTest = new ArrayList<Katakana>();
        this.katakanaToTest.addAll(this.notTenTimesGoodTestedKatakanaList);
        if (!this.useOriginalKatakanaOrder) {
            Collections.shuffle(this.katakanaToTest);
        }
    }

    private void startRealTest() {
        KatakanaTester katakanaTester = new KatakanaTester(this.katakanaToTest, this.dataStructures, this.uiObjects);
        katakanaTester.setVisible(true);
    }
}

