/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.test;

import de.duehl.basics.datetime.DateAndTime;
import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.data.EmptyTranslationsAcceptance;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.test.UserAnswerCorrectnessChecker;
import de.duehl.vocabulary.japanese.logic.translation.GermanToJapaneseTranslation;
import de.duehl.vocabulary.japanese.logic.translation.JapaneseToGermanTranslation;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.testing.VocableListTesterDialog;
import java.util.List;
import javax.swing.SwingUtilities;

public class VocableListTesterLogic {
    private static final long MAX_TIME_IN_SECONDS_TO_ACCEPT_EMPTY_TRANSLATION_AFTER_LAST_TRANSLATION = 3L;
    private final VocabularyTrainerLogic logic;
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private VocableListTesterDialog gui;
    private String kana;
    private String kanji;
    private String germanTerm;
    private String translationByUser;
    private List<Vocable> matchingVocables;
    private DateAndTime lastTranslationMoment;

    public VocableListTesterLogic(List<Vocable> list, String string, VocabularyTrainerLogic vocabularyTrainerLogic, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects) {
        this.logic = vocabularyTrainerLogic;
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        Options options = fumikoDataStructures.getOptions();
        if (options.getTranslationDirection() == TranslationDirection.GERMAN_TO_JAPANESE && !options.isCreateGermanJapaneseTranslationAtStartup() && this.doWeHaveToCreateGermanJapaneseTranslation()) {
            this.createGermanJapaneseTranslation(() -> this.createGui(list, string));
        } else {
            this.createGui(list, string);
        }
    }

    private boolean doWeHaveToCreateGermanJapaneseTranslation() {
        GermanToJapaneseTranslation germanToJapaneseTranslation = this.dataStructures.getGermanToJapaneseTranslation();
        return germanToJapaneseTranslation == null;
    }

    private void createGermanJapaneseTranslation(Runnable runnable) {
        LongTimeProcessInformer longTimeProcessInformer = this.uiObjects.getInformer();
        longTimeProcessInformer.startLongTimeProcess("Erzeuge Datenstrukturen f\u00fcr die Zuordnung von Kana und Kanji zu Vokabeln sowie mehrdeutige Zuordnungen von Kana ohne Kanji zu Vokabeln f\u00fcr die \u00dcbersetzung von Japanisch in Deutsch");
        new Thread(() -> this.createGermanJapaneseTranslationInThread(runnable)).start();
    }

    private void createGermanJapaneseTranslationInThread(Runnable runnable) {
        List<Vocabulary> list = this.dataStructures.getVocabularies();
        GermanToJapaneseTranslation germanToJapaneseTranslation = new GermanToJapaneseTranslation(list);
        SwingUtilities.invokeLater(() -> this.afterCreationGermanJapaneseTranslationInEdt(germanToJapaneseTranslation, runnable));
    }

    private void afterCreationGermanJapaneseTranslationInEdt(GermanToJapaneseTranslation germanToJapaneseTranslation, Runnable runnable) {
        this.dataStructures.setGermanToJapaneseTranslation(germanToJapaneseTranslation);
        LongTimeProcessInformer longTimeProcessInformer = this.uiObjects.getInformer();
        longTimeProcessInformer.endLongTimeProcess();
        runnable.run();
    }

    private void createGui(List<Vocable> list, String string) {
        this.lastTranslationMoment = new DateAndTime();
        this.gui = new VocableListTesterDialog(list, string, this, this.dataStructures, this.uiObjects);
        this.gui.setVisible(true);
    }

    public void test() {
    }

    public void userEnteredJapaneseToGermanTranslation(String string, String string2, String string3) {
        this.kana = string;
        this.kanji = string2;
        this.germanTerm = "";
        this.translationByUser = string3;
        this.matchingVocables = this.createMatchingVocablesForJapaneseToGerman();
        this.userEnteredTranslation();
    }

    private List<Vocable> createMatchingVocablesForJapaneseToGerman() {
        if (this.kanji.isEmpty()) {
            return this.getMatchingVocablesForKana();
        }
        return this.getMatchingVocablesForKanaAndKanji();
    }

    private List<Vocable> getMatchingVocablesForKana() {
        JapaneseToGermanTranslation japaneseToGermanTranslation = this.dataStructures.getJapaneseToGermanTranslation();
        return japaneseToGermanTranslation.getMatchingVocablesForKana(this.kana);
    }

    private List<Vocable> getMatchingVocablesForKanaAndKanji() {
        JapaneseToGermanTranslation japaneseToGermanTranslation = this.dataStructures.getJapaneseToGermanTranslation();
        return japaneseToGermanTranslation.getMatchingVocablesForKanaAndKanji(this.kana, this.kanji);
    }

    public void userEnteredGermanToJapaneseTranslation(String string, String string2) {
        this.kana = "";
        this.kanji = "";
        this.germanTerm = string;
        this.translationByUser = string2;
        this.matchingVocables = this.createMatchingVocablesForGermanToJapanese();
        this.userEnteredTranslation();
    }

    private List<Vocable> createMatchingVocablesForGermanToJapanese() {
        GermanToJapaneseTranslation germanToJapaneseTranslation = this.dataStructures.getGermanToJapaneseTranslation();
        if (null == germanToJapaneseTranslation) {
            throw new RuntimeException("Da ging etwas mit der 'lazy initialization' von germanToJapaneseTranslation schief.");
        }
        return germanToJapaneseTranslation.getMatchingVocablesForGermanTerm(this.germanTerm);
    }

    private void userEnteredTranslation() {
        this.gui.increaseNumberOfDoneVocables();
        Options options = this.dataStructures.getOptions();
        UserAnswerCorrectnessChecker userAnswerCorrectnessChecker = new UserAnswerCorrectnessChecker(options, this.translationByUser, this.matchingVocables);
        userAnswerCorrectnessChecker.check();
        boolean bl = userAnswerCorrectnessChecker.isCorrect();
        Vocable vocable = userAnswerCorrectnessChecker.getCorrectVocable();
        if (bl) {
            this.gui.increaseNumberOfCorrectDoneVocables();
        }
        this.gui.setNumbersAndPercent();
        boolean bl2 = this.gui.informAboutTranslationSuccess(this.matchingVocables, bl, vocable);
        if (!bl && bl2) {
            this.gui.increaseNumberOfCorrectDoneVocables();
            this.gui.setNumbersAndPercent();
            vocable = this.matchingVocables.size() == 1 ? this.matchingVocables.get(0) : this.gui.letUserSelectMatchingVocableForHisTranslation(this.translationByUser, this.matchingVocables);
            bl = true;
        }
        this.saveUserTestAnswerInInternalData(this.matchingVocables, bl, vocable);
        this.lastTranslationMoment = new DateAndTime();
        if (options.isSwitchToNextVocableAfterEntringTranslation()) {
            this.gui.switchToNextVocable();
        }
    }

    private void saveUserTestAnswerInInternalData(List<Vocable> list, boolean bl, Vocable vocable) {
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        if (bl) {
            InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
            this.tested(internalAdditionalVocableData, bl);
            int n = this.getLastCorrectTestsCount(vocable);
            if (n >= 10) {
                this.logic.removeVocableFromWrongTestedVocablesList(vocable);
            }
        } else {
            for (Vocable vocable2 : list) {
                InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable2);
                this.tested(internalAdditionalVocableData, bl);
                this.logic.addVocableToWrongTestedVocablesList(vocable2);
            }
        }
    }

    private void tested(InternalAdditionalVocableData internalAdditionalVocableData, boolean bl) {
        Options options = this.dataStructures.getOptions();
        TranslationDirection translationDirection = options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            internalAdditionalVocableData.testedJapaneseToGerman(bl);
        } else if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            internalAdditionalVocableData.testedGermanToJapanese(bl);
        } else {
            throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + translationDirection);
        }
    }

    private int getLastCorrectTestsCount(Vocable vocable) {
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
        Options options = this.dataStructures.getOptions();
        TranslationDirection translationDirection = options.getTranslationDirection();
        if (translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            return internalAdditionalVocableData.getLastCorrectJapaneseToGermanTestsCount();
        }
        if (translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            return internalAdditionalVocableData.getLastCorrectGermanToJapaneseTestsCount();
        }
        throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + translationDirection);
    }

    public boolean doWeHaveToReactOnEmptyTranslation() {
        Options options = this.dataStructures.getOptions();
        EmptyTranslationsAcceptance emptyTranslationsAcceptance = options.getEmptyTranslationsAcceptance();
        switch (emptyTranslationsAcceptance) {
            case ALWAYS: {
                return true;
            }
            case NOT_IMMEDIATELY: {
                DateAndTime dateAndTime = new DateAndTime();
                long l = this.lastTranslationMoment.difference(dateAndTime);
                return l > 3L;
            }
            case NEVER: {
                return false;
            }
        }
        throw new RuntimeException("Unbekannte Art auf eine leere \u00dcbersetzung zu reagieren: '" + emptyTranslationsAcceptance.getOptionDescription() + "'");
    }
}

