/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.translation;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.translation.data.KanaAndKanji;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JapaneseToGermanTranslation {
    private static final boolean PRINT_MULTIPLE_VOCABLE_ONLY_KANA = false;
    private final List<Vocabulary> vocabularies;
    private final Map<String, List<Vocable>> vocablesByKana;
    private final Map<KanaAndKanji, List<Vocable>> vocablesByKanaAndKanji;

    public JapaneseToGermanTranslation(List<Vocabulary> list) {
        this.vocabularies = list;
        this.vocablesByKana = new HashMap<String, List<Vocable>>();
        this.vocablesByKanaAndKanji = new HashMap<KanaAndKanji, List<Vocable>>();
        this.fillHashes();
        this.printMultipleVocableOnlyKana();
    }

    private void fillHashes() {
        for (Vocabulary vocabulary : this.vocabularies) {
            this.fillHashesForVocabulary(vocabulary);
        }
    }

    private void fillHashesForVocabulary(Vocabulary vocabulary) {
        for (Vocable vocable : vocabulary.getVocables()) {
            this.fillKanaHashForVocable(vocable);
            this.fillKanaAndKanjiHashForVocable(vocable);
        }
    }

    private void fillKanaHashForVocable(Vocable vocable) {
        List<Vocable> list;
        String string = vocable.getKana();
        if (!this.vocablesByKana.containsKey(string)) {
            this.vocablesByKana.put(string, new ArrayList());
        }
        if (!(list = this.vocablesByKana.get(string)).contains(vocable)) {
            list.add(vocable);
        }
    }

    private void fillKanaAndKanjiHashForVocable(Vocable vocable) {
        List<Vocable> list;
        String string;
        String string2 = vocable.getKana();
        KanaAndKanji kanaAndKanji = new KanaAndKanji(string2, string = vocable.getKanji());
        if (!this.vocablesByKanaAndKanji.containsKey(kanaAndKanji)) {
            this.vocablesByKanaAndKanji.put(kanaAndKanji, new ArrayList());
        }
        if (!(list = this.vocablesByKanaAndKanji.get(kanaAndKanji)).contains(vocable)) {
            list.add(vocable);
        }
    }

    private void printMultipleVocableOnlyKana() {
    }

    private void reallyPrintMultipleVocableOnlyKana() {
        System.out.println("Alle Kana, die zu mehr als einer Vokabel passen:");
        List<String> list = CollectionsHelper.getSortedMapStringIndices(this.vocablesByKana);
        for (String string : list) {
            List<Vocable> list2 = this.vocablesByKana.get(string);
            if (list2.size() <= 1) continue;
            System.out.print(string);
            for (Vocable vocable : list2) {
                System.out.print(" - " + vocable.getKanji() + " " + vocable.getKana() + " " + vocable.getTranslations().get(0));
            }
            System.out.println();
        }
    }

    public List<Vocable> getMatchingVocablesForKana(String string) {
        if (this.vocablesByKana.containsKey(string)) {
            return this.vocablesByKana.get(string);
        }
        throw new RuntimeException("Zur Darstelung in Kana '" + string + "' ist keine zugeh\u00f6rige Vokabel bekannt.");
    }

    public List<Vocable> getMatchingVocablesForKanaAndKanji(String string, String string2) {
        KanaAndKanji kanaAndKanji = new KanaAndKanji(string, string2);
        if (this.vocablesByKanaAndKanji.containsKey(kanaAndKanji)) {
            return this.vocablesByKanaAndKanji.get(kanaAndKanji);
        }
        throw new RuntimeException("Zur Darstelung in Kana '" + string + "' und Kanji '" + string2 + "'ist keine zugeh\u00f6rige Vokabel bekannt.");
    }
}

