/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.logic.steps;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.startup.ui.data.MessageAppender;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;
import java.util.ArrayList;
import java.util.List;

public abstract class StartupStep
implements MessageAppender {
    private static final boolean DEBUG = false;
    protected final String step;
    protected final Options options;
    private final SplashScreenable splashScreen;
    private final StopWatch watch;
    private boolean warningsInStep;
    private boolean errorsInStep;
    private String errorMessage;
    private List<String> warningMessages;

    public StartupStep(String string, Options options, SplashScreenable splashScreenable, StopWatch stopWatch) {
        this.step = string;
        this.options = options;
        this.splashScreen = splashScreenable;
        this.watch = stopWatch;
        this.warningMessages = new ArrayList<String>();
    }

    public final boolean isWarningsInStep() {
        return this.warningsInStep;
    }

    protected final void warningsInStep(String string) {
        this.warningMessages.add(string);
        this.warningsInStep = true;
    }

    public final boolean isErrorsInStep() {
        return this.errorsInStep;
    }

    protected final void errorsInStep(String string) {
        this.errorMessage = string;
        this.errorsInStep = true;
    }

    public final void runStep() {
        this.startStep(this.step);
        this.runInternalStep();
        this.endStep(this.step);
    }

    private void startStep(String string) {
        this.splashScreen.startStep(string);
        this.warningsInStep = false;
        this.errorsInStep = false;
    }

    protected abstract void runInternalStep();

    private void endStep(String string) {
        if (this.errorsInStep) {
            this.splashScreen.stepError(string);
        } else if (this.warningsInStep) {
            this.splashScreen.stepWarning(string);
        } else {
            this.splashScreen.stepGood(string);
        }
    }

    @Override
    public void appendMessage(String string) {
        Object object;
        if (this.options.isShowTimestampsInStartup()) {
            if (string.isBlank()) {
                object = string;
            } else {
                String string2 = this.watch.getTime() + " - ";
                if (string.startsWith(" ")) {
                    int n = Text.findIndexOfFirstNonSpace(string);
                    if (n == -1) {
                        throw new RuntimeException("Kann nicht sein, die Nachricht beginnt mit einem Leerzeichen, ist nicht blank, aber ich finde nicht den Index des ersten Nicht-Leerzeichens.");
                    }
                    String string3 = string.substring(0, n);
                    String string4 = string.substring(n);
                    object = string3 + string2 + string4;
                } else {
                    object = string2 + string;
                }
            }
        } else {
            object = string;
        }
        this.splashScreen.appendMessage((String)object);
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public List<String> getWarningMessages() {
        return this.warningMessages;
    }
}

