/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.logic.steps;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.startup.logic.steps.StartupStep;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Step03FindMP3AndStoreInVocables
extends StartupStep {
    private static final boolean INFORM_ABOUT_EACH_VOCABULARY_SOUND_FILE_CREATION = false;
    private static final int MAXIMUM_ERRORS_TO_SHOW = 25;
    private static final int MAXIMUM_WARNINGS_TO_SHOW = 10;
    private final List<Vocabulary> vocabularies;
    private List<String> doubleMp3BareFilenamesMessages;
    private Map<String, String> bareFilename2FilenameMap;
    private List<String> missingMp3BareFilesMessages;
    private List<String> missingMp3FilesMessages;

    public Step03FindMP3AndStoreInVocables(String string, Options options, SplashScreenable splashScreenable, StopWatch stopWatch, List<Vocabulary> list) {
        super(string, options, splashScreenable, stopWatch);
        this.vocabularies = list;
    }

    @Override
    protected void runInternalStep() {
        if (!this.isErrorsInStep()) {
            this.determineAllSoundFiles();
        }
        if (!this.isErrorsInStep()) {
            this.adjustMp3InAllVocables();
        }
    }

    private void determineAllSoundFiles() {
        this.appendMessage("Suche die Sound-Dateien zu allen Vokabeln ...");
        this.doubleMp3BareFilenamesMessages = new ArrayList<String>();
        String string = this.options.getVocabulariesPath();
        List<String> list = FileHelper.findFilesNio2(string, ".mp3");
        this.bareFilename2FilenameMap = new HashMap<String, String>();
        for (String string2 : list) {
            String string3 = FileHelper.getBareName(string2);
            if (this.bareFilename2FilenameMap.containsKey(string3)) {
                this.doubleMp3BareFilenamesMessages.add("    Die MP3-Datei " + string3 + " ist zweimal vorhanden:\n        Datei 1: " + this.bareFilename2FilenameMap.get(string3) + "\n        Datei 2: " + string2 + "\n");
            }
            this.bareFilename2FilenameMap.put(string3, string2);
        }
        if (!this.doubleMp3BareFilenamesMessages.isEmpty()) {
            this.reportDoubleMp3BareFilenames();
        }
    }

    private void reportDoubleMp3BareFilenames() {
        String string = "Achtung, es kommen Dateinamen (ohne Pfad) von MP3-Dateien mehrfach vor:";
        if (this.options.isInformAboutDoubleMp3AtStartup()) {
            this.reportErrors(string, this.doubleMp3BareFilenamesMessages);
        } else {
            this.reportWarnings(string, this.doubleMp3BareFilenamesMessages);
        }
    }

    private void adjustMp3InAllVocables() {
        this.appendMessage("Trage die gefundenen Sound-Dateien in allen Vokabeln ein ...");
        this.missingMp3BareFilesMessages = new ArrayList<String>();
        this.missingMp3FilesMessages = new ArrayList<String>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                this.searchAndStoreSoundFileWithPath(vocable);
            }
        }
        if (!this.missingMp3BareFilesMessages.isEmpty()) {
            this.reportMissingMp3BareFilesAndExit();
        }
        if (!this.missingMp3FilesMessages.isEmpty()) {
            this.reportMissingMp3FilesAndExit();
        }
    }

    private void searchAndStoreSoundFileWithPath(Vocable vocable) {
        String string = vocable.getBareMp3();
        if (string.isBlank()) {
            this.missingMp3BareFilesMessages.add("    Die Sound-Datei ohne Pfad '" + string + "' ist leer.\n        vocable = " + vocable + "\n");
        } else if (this.bareFilename2FilenameMap.containsKey(string)) {
            String string2 = this.bareFilename2FilenameMap.get(string);
            vocable.setMp3(string2);
        } else {
            this.missingMp3FilesMessages.add("    Die Sound-Datei '" + string + "' wurde nicht gefunden.\n        vocable = " + vocable + "\n");
        }
    }

    private void reportMissingMp3BareFilesAndExit() {
        this.reportErrors("Es gibt Vokabeln ohne eingetragenen Namen der MP3-Datei (ohne Pfad):", this.missingMp3BareFilesMessages);
    }

    private void reportMissingMp3FilesAndExit() {
        int n = this.missingMp3FilesMessages.size();
        String string = "Es gibt " + n + " Vokabeln zu denen keine MP3-Datei (mit Pfad) gefunden wurde";
        String string2 = string + ":";
        if (this.options.isAllowMissingMp3()) {
            if (this.options.isReportMissingMp3()) {
                this.reportWarnings(string2, this.missingMp3FilesMessages);
            }
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string).append(".\n\n");
            int n2 = Math.min(3, n);
            boolean bl = n2 < n;
            for (int i = 0; i < n2; ++i) {
                if (n2 > 1) {
                    stringBuilder.append(i + 1 + ")");
                }
                stringBuilder.append(this.missingMp3FilesMessages.get(i)).append("\n");
            }
            if (bl) {
                stringBuilder.append("...\n");
            }
            stringBuilder.append("\nSoll trrotzdem gestartet werden?\nDann wird auch die Option, dass trotz fehlender MP3-Dateien gestartet wird, gesetzt.");
            String string3 = stringBuilder.toString();
            boolean bl2 = GuiTools.askUser(string, string3);
            if (bl2) {
                this.options.setAllowMissingMp3(true);
            } else {
                this.reportErrors(string2, this.doubleMp3BareFilenamesMessages);
            }
        }
    }

    private void reportErrors(String string, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        int n = list.size();
        boolean bl = n > 25;
        int n2 = Math.min(n, 25);
        for (int i = 0; i < n2; ++i) {
            if (list.size() > 1) {
                arrayList.add(i + 1 + ") ");
            }
            arrayList.add(list.get(i));
        }
        if (bl) {
            arrayList.add("... und " + NumberString.taupu(n - n2) + " weitere Fehler dieser Art.");
        }
        this.errorsInStep(Text.joinWithLineBreak(arrayList));
    }

    private void reportWarnings(String string, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        int n = list.size();
        boolean bl = n > 10;
        int n2 = Math.min(n, 10);
        for (int i = 0; i < n2; ++i) {
            if (list.size() > 1) {
                arrayList.add(i + 1 + ") ");
            }
            arrayList.add(list.get(i));
        }
        if (bl) {
            arrayList.add("... und " + NumberString.taupu(n - n2) + " weitere Warnungen dieser Art.");
        }
        String string2 = Text.joinWithLineBreak(arrayList);
        this.appendMessage(string2);
        this.warningsInStep(string2);
    }
}

