/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.logic.steps;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.KeyToVocableMapCreator;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.startup.logic.steps.StartupStep;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import java.util.List;
import java.util.Map;

public class Step09InitOwnLists
extends StartupStep {
    private final VocabularyTrainerGui gui;
    private final List<Vocabulary> vocabularies;
    private final InternalDataRequester internalDataRequester;
    private Map<String, Vocable> keyToVocable;
    private OwnLists ownLists;

    public Step09InitOwnLists(String string, VocabularyTrainerGui vocabularyTrainerGui, Options options, SplashScreenable splashScreenable, StopWatch stopWatch, List<Vocabulary> list, InternalDataRequester internalDataRequester) {
        super(string, options, splashScreenable, stopWatch);
        this.gui = vocabularyTrainerGui;
        this.vocabularies = list;
        this.internalDataRequester = internalDataRequester;
    }

    @Override
    protected void runInternalStep() {
        this.appendMessage("Erzeuge Verzeichnis Schl\u00fcssel zu Vokabel ...");
        KeyToVocableMapCreator keyToVocableMapCreator = new KeyToVocableMapCreator(this.vocabularies, this.internalDataRequester);
        keyToVocableMapCreator.create();
        this.keyToVocable = keyToVocableMapCreator.getKeyToVocable();
        this.appendMessage("Erzeuge Verwaltung der eigene Listen ...");
        this.ownLists = new OwnLists(this.vocabularies, this.keyToVocable, this.internalDataRequester, this.options, this.gui);
    }

    public Map<String, Vocable> getKeyToVocable() {
        return this.keyToVocable;
    }

    public void setKeyToVocable(Map<String, Vocable> map) {
        this.keyToVocable = map;
    }

    public OwnLists getOwnLists() {
        return this.ownLists;
    }
}

