/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.ui;

import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.swing.ui.lights.CheckLight;
import de.duehl.swing.ui.lights.data.CheckLightMode;
import de.duehl.vocabulary.japanese.startup.ui.data.SplashScreenable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class SplashScreen
extends NonModalFrameDialogBase
implements SplashScreenable {
    private static final CheckLightMode CHECK_LIGHT_MODE = CheckLightMode.THREE;
    private final List<String> steps;
    private final List<CheckLight> stepLights;
    private final StringBuilder splashTextBuilder;
    private final JTextArea startupTextArea;
    private final JTextArea actualStepTextArea;
    private final JLabel finishedStepsRuntimeLabel;
    private final StopWatch finishedStepsRuntimeWatch;
    private boolean canClose;

    public SplashScreen(List<String> list, Image image) {
        super(new Point(150, 100), image, "Start von Fumikos Vokabel-Trainer");
        this.addClosingWindowListener(() -> this.closeDialogIfDone());
        this.steps = list;
        this.stepLights = this.createStepLights();
        this.splashTextBuilder = new StringBuilder();
        this.startupTextArea = new JTextArea();
        this.actualStepTextArea = new JTextArea();
        this.finishedStepsRuntimeLabel = new JLabel();
        this.finishedStepsRuntimeWatch = new StopWatch();
        this.canClose = false;
        this.init();
        this.fillDialog();
    }

    private List<CheckLight> createStepLights() {
        ArrayList<CheckLight> arrayList = new ArrayList<CheckLight>();
        for (String string : this.steps) {
            CheckLight checkLight = new CheckLight(CHECK_LIGHT_MODE, string);
            arrayList.add(checkLight);
        }
        return arrayList;
    }

    private void init() {
        this.initTextArea();
        this.initActualStepTextArea();
        this.initFinishedStepsRuntimeLabel();
    }

    private void initTextArea() {
        this.startupTextArea.setRows(45);
        this.startupTextArea.setColumns(100);
        this.startupTextArea.setEditable(false);
        this.startupTextArea.setFocusable(false);
    }

    private void initActualStepTextArea() {
        this.actualStepTextArea.setRows(3);
        this.actualStepTextArea.setColumns(80);
        this.actualStepTextArea.setEditable(false);
        this.actualStepTextArea.setFocusable(false);
        GuiTools.biggerFont(this.actualStepTextArea, 10);
    }

    private void initFinishedStepsRuntimeLabel() {
        GuiTools.biggerFont(this.finishedStepsRuntimeLabel, 15);
        this.finishedStepsRuntimeLabel.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        this.actualiseFinishedStepsRuntimeLabel();
    }

    @Override
    protected void populateDialog() {
        this.add(this.createStepLightsPart(), "West");
        this.add(this.createMainPart(), "Center");
    }

    private Component createStepLightsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(7, 3));
        for (CheckLight checkLight : this.stepLights) {
            jPanel.add(checkLight.getPanel());
        }
        return jPanel;
    }

    private Component createMainPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createActualStepTextAndFinishedStepsRuntimePart(), "North");
        jPanel.add((Component)GuiTools.createScrollPane(this.startupTextArea), "Center");
        return jPanel;
    }

    private Component createActualStepTextAndFinishedStepsRuntimePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.actualStepTextArea, "Center");
        jPanel.add((Component)this.finishedStepsRuntimeLabel, "East");
        return jPanel;
    }

    @Override
    public void appendMessage(String string) {
        this.appendMessageToSplashTextBuilder(string);
        this.appendMessageToTextArea(string);
    }

    private void appendMessageToSplashTextBuilder(String string) {
        this.splashTextBuilder.append(string).append("\n");
    }

    private void appendMessageToTextArea(String string) {
        try {
            this.tryToAppendMessageToTextArea(string);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Kann die Nachricht [" + string + "] nicht an das Ende des Dokuments der JTextArea des SplashScreens anh\u00e4ngen.");
        }
    }

    private void tryToAppendMessageToTextArea(String string) throws BadLocationException {
        Document document = this.startupTextArea.getDocument();
        document.insertString(document.getLength(), string + "\n", null);
        this.startupTextArea.setCaretPosition(this.startupTextArea.getDocument().getLength());
    }

    @Override
    public void startStep(String string) {
        CheckLight checkLight = this.determineLightByStep(string);
        checkLight.setBlack();
        this.actualStepTextArea.setText(string);
    }

    @Override
    public void stepGood(String string) {
        CheckLight checkLight = this.determineLightByStep(string);
        checkLight.setGreen();
        this.actualStepTextArea.setText("");
        this.actualiseFinishedStepsRuntimeLabel();
    }

    @Override
    public void stepWarning(String string) {
        CheckLight checkLight = this.determineLightByStep(string);
        checkLight.setYellow();
        this.actualStepTextArea.setText("");
        this.actualiseFinishedStepsRuntimeLabel();
    }

    @Override
    public void stepError(String string) {
        CheckLight checkLight = this.determineLightByStep(string);
        checkLight.setRed();
        this.actualStepTextArea.setText("");
        this.actualiseFinishedStepsRuntimeLabel();
    }

    private CheckLight determineLightByStep(String string) {
        int n = this.steps.indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException("Unbekannter Schritt '" + string + "'.");
        }
        CheckLight checkLight = this.stepLights.get(n);
        return checkLight;
    }

    private void actualiseFinishedStepsRuntimeLabel() {
        this.finishedStepsRuntimeLabel.setText(this.finishedStepsRuntimeWatch.getTime());
    }

    public void canClose() {
        this.canClose = true;
    }

    private void closeDialogIfDone() {
        if (this.canClose) {
            this.closeDialog();
        }
    }

    public String getSplashText() {
        return this.splashTextBuilder.toString();
    }
}

