/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.tools;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.data.VocablesShuffleType;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.tools.data.VocableSortData;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VocableListShuffler {
    private static final boolean DEBUG = false;
    private final List<Vocable> vocables;
    private final VocablesShuffleType type;
    private final FumikoDataStructures dataStructures;
    private final TranslationDirection translationDirection;
    private Map<Vocable, VocableSortData> sortDataByVocableMap;
    private static final int TEST_COUNT_FACTOR = 1;
    private static final int LAST_CORRECT_TEST_DATE_FACTOR = 20;
    private static final int LAST_ANSWERS_SUCCESS_FACTOR = 100;

    public VocableListShuffler(List<Vocable> list, VocablesShuffleType vocablesShuffleType, FumikoDataStructures fumikoDataStructures) {
        this.vocables = CollectionsHelper.copyList(list);
        this.type = vocablesShuffleType;
        this.dataStructures = fumikoDataStructures;
        Options options = fumikoDataStructures.getOptions();
        this.translationDirection = options.getTranslationDirection();
    }

    public void shuffle() {
        switch (this.type) {
            case NATURAL: {
                this.shuffleNatural();
                break;
            }
            case ALPHABETICAL: {
                this.shuffleAlphabetical();
                break;
            }
            case RANDOM: {
                this.shuffleRandom();
                break;
            }
            case LAST_CORRECT_TEST_DATE: {
                this.shuffleByLastCorrectTestDate();
                break;
            }
            case FIRST_SEEN_DATE: {
                this.shuffleByFirstSeenDate();
                break;
            }
            case LAST_ANSWERS_SUCCESS: {
                this.shuffleByLastAnswersSuccess();
                break;
            }
            case MIX: {
                this.shuffleByMix();
                break;
            }
            default: {
                this.shuffleUnknown();
            }
        }
        Options options = this.dataStructures.getOptions();
        if (options.isReverseShuffledVocables()) {
            this.revers();
        }
    }

    private void shuffleNatural() {
        VocableListShuffler.say("shuffleNatural()");
    }

    private void shuffleAlphabetical() {
        VocableListShuffler.say("shuffleAlphabetical()");
        Collections.sort(this.vocables, new Comparator<Vocable>(){

            @Override
            public int compare(Vocable vocable, Vocable vocable2) {
                String string = vocable.getRomaji();
                String string2 = vocable2.getRomaji();
                return string.compareTo(string2);
            }
        });
    }

    private void shuffleRandom() {
        VocableListShuffler.say("shuffleRandom()");
        Collections.shuffle(this.vocables);
    }

    private void shuffleByLastCorrectTestDate() {
        VocableListShuffler.say("shuffleByLastCorrectTestDate()");
        this.determineVocableSortData();
        Collections.sort(this.vocables, new Comparator<Vocable>(){

            @Override
            public int compare(Vocable vocable, Vocable vocable2) {
                return VocableListShuffler.this.compareByLastCorrectTestDate(vocable, vocable2);
            }
        });
    }

    private int compareByLastCorrectTestDate(Vocable vocable, Vocable vocable2) {
        VocableListShuffler.say("compareByLastCorrectTestDate(vocable1, vocable2)");
        VocableListShuffler.say("vocable1 : " + vocable);
        VocableListShuffler.say("vocable2 : " + vocable2);
        VocableSortData vocableSortData = this.sortDataByVocableMap.get(vocable);
        VocableSortData vocableSortData2 = this.sortDataByVocableMap.get(vocable2);
        VocableListShuffler.say("sortData1 : " + vocableSortData);
        VocableListShuffler.say("sortData2 : " + vocableSortData2);
        int n = vocableSortData.getLastCorrectAgoInDays();
        int n2 = vocableSortData2.getLastCorrectAgoInDays();
        VocableListShuffler.say("daysSinceLastCorrect1 : " + n);
        VocableListShuffler.say("daysSinceLastCorrect2 : " + n2);
        int n3 = n - n2;
        VocableListShuffler.say("cmp : " + n3);
        return n3;
    }

    private void shuffleByFirstSeenDate() {
        VocableListShuffler.say("shuffleByFirstSeenDate()");
        this.determineVocableSortData();
        Collections.sort(this.vocables, new Comparator<Vocable>(){

            @Override
            public int compare(Vocable vocable, Vocable vocable2) {
                return VocableListShuffler.this.compareByFirstSeenDate(vocable, vocable2);
            }
        });
    }

    private int compareByFirstSeenDate(Vocable vocable, Vocable vocable2) {
        VocableListShuffler.say("compareByFirstSeenDate(vocable1, vocable2)");
        VocableListShuffler.say("vocable1 : " + vocable);
        VocableListShuffler.say("vocable2 : " + vocable2);
        VocableSortData vocableSortData = this.sortDataByVocableMap.get(vocable);
        VocableSortData vocableSortData2 = this.sortDataByVocableMap.get(vocable2);
        VocableListShuffler.say("sortData1 : " + vocableSortData);
        VocableListShuffler.say("sortData2 : " + vocableSortData2);
        int n = vocableSortData.getAgeInDays();
        int n2 = vocableSortData2.getAgeInDays();
        VocableListShuffler.say("daysSinceFirstSeen1 : " + n);
        VocableListShuffler.say("daysSinceFirstSeen2 : " + n2);
        int n3 = n - n2;
        VocableListShuffler.say("cmp : " + n3);
        return n3;
    }

    private void shuffleByLastAnswersSuccess() {
        VocableListShuffler.say("shuffleByLastAnswersSuccess()");
        this.determineVocableSortData();
        Collections.sort(this.vocables, new Comparator<Vocable>(){

            @Override
            public int compare(Vocable vocable, Vocable vocable2) {
                return VocableListShuffler.this.compareByLastAnswersSuccess(vocable, vocable2);
            }
        });
    }

    private int compareByLastAnswersSuccess(Vocable vocable, Vocable vocable2) {
        VocableListShuffler.say("compareByLastAnswersSuccess(vocable1, vocable2)");
        VocableListShuffler.say("vocable1 : " + vocable);
        VocableListShuffler.say("vocable2 : " + vocable2);
        VocableSortData vocableSortData = this.sortDataByVocableMap.get(vocable);
        VocableSortData vocableSortData2 = this.sortDataByVocableMap.get(vocable2);
        VocableListShuffler.say("sortData1 : " + vocableSortData);
        VocableListShuffler.say("sortData2 : " + vocableSortData2);
        double d = vocableSortData.getLastAnswersValue();
        double d2 = vocableSortData2.getLastAnswersValue();
        int n = (int)(d - d2);
        VocableListShuffler.say("cmp lastSuccess: " + n);
        if (n == 0) {
            int n2 = vocableSortData.getCountLastCorrectAnswers();
            int n3 = vocableSortData2.getCountLastCorrectAnswers();
            n = n2 - n3;
            VocableListShuffler.say("cmp countLastCorrectAnswers: " + n);
            if (n == 0) {
                int n4 = vocableSortData.getCountLastIncorrectAnswers();
                int n5 = vocableSortData2.getCountLastIncorrectAnswers();
                n = n5 - n4;
                VocableListShuffler.say("cmp countLastIncorrectAnswers: " + n);
            }
        }
        return n;
    }

    private void shuffleByMix() {
        VocableListShuffler.say("shuffleByMix()");
        this.determineVocableSortData();
        Collections.sort(this.vocables, new Comparator<Vocable>(){

            @Override
            public int compare(Vocable vocable, Vocable vocable2) {
                return VocableListShuffler.this.compareByMix(vocable, vocable2);
            }
        });
    }

    private int compareByMix(Vocable vocable, Vocable vocable2) {
        VocableListShuffler.say("compareByMix(vocable1, vocable2)");
        VocableListShuffler.say("vocable1 : " + vocable);
        VocableListShuffler.say("vocable2 : " + vocable2);
        VocableSortData vocableSortData = this.sortDataByVocableMap.get(vocable);
        VocableSortData vocableSortData2 = this.sortDataByVocableMap.get(vocable2);
        VocableListShuffler.say("sortData1 : " + vocableSortData);
        VocableListShuffler.say("sortData2 : " + vocableSortData2);
        int n = vocableSortData.getTestCount();
        int n2 = vocableSortData2.getTestCount();
        int n3 = n - n2;
        VocableListShuffler.say("cmpTestCount = " + n3);
        int n4 = this.compareByLastCorrectTestDate(vocable, vocable2);
        VocableListShuffler.say("cmpByLastCorrectTestDate = " + n4);
        int n5 = this.compareByLastAnswersSuccess(vocable, vocable2);
        VocableListShuffler.say("cmpByLastAnswersSuccess = " + n5);
        int n6 = 0 + 1 * n3 + 20 * n4 + 100 * n5;
        VocableListShuffler.say("cmp = " + n6);
        return n6;
    }

    private void determineVocableSortData() {
        VocableListShuffler.say("determineVocableSortData()");
        this.sortDataByVocableMap = new HashMap<Vocable, VocableSortData>();
        for (Vocable vocable : this.vocables) {
            VocableSortData vocableSortData = this.determineVocableSortData(vocable);
            this.sortDataByVocableMap.put(vocable, vocableSortData);
        }
    }

    private VocableSortData determineVocableSortData(Vocable vocable) {
        InternalDataRequester internalDataRequester = this.dataStructures.getInternalDataRequester();
        InternalAdditionalVocableData internalAdditionalVocableData = internalDataRequester.getInternalDataForVocable(vocable);
        ImmutualDate immutualDate = new ImmutualDate();
        int n = this.getLastCorectAgoInDays(internalAdditionalVocableData, immutualDate);
        int n2 = internalAdditionalVocableData.getFirstSeenDate().difference(immutualDate);
        double d = 0.0;
        int n3 = 0;
        int n4 = 0;
        List<Boolean> list = this.getLastTenTestResults(internalAdditionalVocableData);
        if (!list.isEmpty()) {
            for (boolean bl : list) {
                if (bl) {
                    d += 1.0;
                    ++n3;
                    continue;
                }
                ++n4;
            }
            d /= (double)list.size();
            d *= 100.0;
        }
        int n5 = this.getTestCount(internalAdditionalVocableData);
        return new VocableSortData(n, n2, d, n3, n4, n5);
    }

    private int getLastCorectAgoInDays(InternalAdditionalVocableData internalAdditionalVocableData, ImmutualDate immutualDate) {
        ImmutualDate immutualDate2 = this.getLastCorrectTestDate(internalAdditionalVocableData);
        return immutualDate2.difference(immutualDate);
    }

    private ImmutualDate getLastCorrectTestDate(InternalAdditionalVocableData internalAdditionalVocableData) {
        if (this.translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            return internalAdditionalVocableData.getLastCorrectJapaneseToGermanTestDate();
        }
        if (this.translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            return internalAdditionalVocableData.getLastCorrectGermanToJapaneseTestDate();
        }
        throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + this.translationDirection);
    }

    private List<Boolean> getLastTenTestResults(InternalAdditionalVocableData internalAdditionalVocableData) {
        if (this.translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            return internalAdditionalVocableData.getLastTenJapaneseToGermanTestResults();
        }
        if (this.translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            return internalAdditionalVocableData.getLastTenGermanToJapaneseTestResults();
        }
        throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + this.translationDirection);
    }

    private int getTestCount(InternalAdditionalVocableData internalAdditionalVocableData) {
        if (this.translationDirection == TranslationDirection.JAPANESE_TO_GERMAN) {
            return internalAdditionalVocableData.getJapaneseToGermanTestCount();
        }
        if (this.translationDirection == TranslationDirection.GERMAN_TO_JAPANESE) {
            return internalAdditionalVocableData.getGermanToJapaneseTestCount();
        }
        throw new RuntimeException("Unbekannte \u00dcbersetzungsrichtung " + this.translationDirection);
    }

    private void shuffleUnknown() {
        GuiTools.informUser("Unbekannte Art eine Vokabelliste zu sortieren", "Die Art '" + this.type + "' die Vokabelliste zu sortieren ist unbekannt.\n\nDaher wird die Vokabelliste rein zuf\u00e4llig sortiert.");
        this.shuffleRandom();
    }

    private void revers() {
        Collections.reverse(this.vocables);
    }

    public List<Vocable> getVocables() {
        return this.vocables;
    }

    private static void say(String string) {
    }
}

