/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components.text;

import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.data.Vocable;

public class RomajiAndPronunciationTextCreator {
    private static final int CHARACTERS_PER_LINE = 35;
    private final Vocable vocable;
    private final boolean showRomaji;
    private final boolean showPronunciation;
    private String firstTextPart;
    private String textPartInBrace;
    private boolean braceInOwnLine;

    public RomajiAndPronunciationTextCreator(Vocable vocable, boolean bl, boolean bl2) {
        this.vocable = vocable;
        this.showRomaji = bl;
        this.showPronunciation = bl2;
    }

    public void create() {
        this.initializeTexts();
        this.breakLongTexts();
    }

    private void initializeTexts() {
        this.firstTextPart = this.vocable.getRomaji();
        this.textPartInBrace = this.vocable.getPronunciation();
        if (!this.showPronunciation) {
            this.textPartInBrace = "";
        }
        if (!this.showRomaji) {
            this.firstTextPart = this.textPartInBrace;
            this.textPartInBrace = "";
        }
        this.braceInOwnLine = !this.textPartInBrace.isEmpty() && this.firstTextPart.length() + this.textPartInBrace.length() + 5 > 35;
    }

    private void breakLongTexts() {
        this.firstTextPart = this.breakLongText(this.firstTextPart);
        this.textPartInBrace = this.breakLongText(this.textPartInBrace);
    }

    private String breakLongText(String string) {
        if (string.length() > 35) {
            return Text.addLineBreaks(string, 35);
        }
        return string;
    }

    public String getFirstTextPart() {
        return this.firstTextPart;
    }

    public String getTextPartInBrace() {
        return this.textPartInBrace;
    }

    public boolean isBraceInOwnLine() {
        return this.braceInOwnLine;
    }
}

