/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.creation.menu;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class GrammarMenuCreation
implements SingleMenuCreation {
    private final VocabularyTrainerGui gui;

    public GrammarMenuCreation(VocabularyTrainerGui vocabularyTrainerGui) {
        this.gui = vocabularyTrainerGui;
    }

    @Override
    public JMenu createTheMenu() {
        JMenu jMenu = new JMenu("Grammatik");
        jMenu.setMnemonic('g');
        jMenu.add(this.createShowVerbsInWoerterbuchformAsListMenuItem());
        jMenu.add(this.createShowAdjectivesInPositivePresenceAsListMenuItem());
        jMenu.add(this.createShowIAdjectivesInPositivePresenceAsListMenuItem());
        jMenu.add(this.createShowNaAdjectivesInPositivePresenceAsListMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createShowListOfNaAdjectivesEndingWithIMenuItem());
        jMenu.add(this.createShowListOfIruEruExceptionVerbsMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createCreateVerbOrAdjectiveTablesMenuItem());
        return jMenu;
    }

    private JMenuItem createShowVerbsInWoerterbuchformAsListMenuItem() {
        return new MyMenuItem("Verben in W\u00f6rterbuchform als Liste anzeigen ...").mnemonic('v').accelerator(87, 128).actionListener(actionEvent -> this.gui.showVerbsInWoerterbuchformAsList());
    }

    private JMenuItem createShowAdjectivesInPositivePresenceAsListMenuItem() {
        return new MyMenuItem("Adjektive in Grundform (positive Gegenwart) als Liste anzeigen ...").mnemonic('a').accelerator(71, 128).actionListener(actionEvent -> this.gui.showAdjectivesInPositivePresenceAsList());
    }

    private JMenuItem createShowIAdjectivesInPositivePresenceAsListMenuItem() {
        return new MyMenuItem("\u3044-Adjektive in Grundform (positive Gegenwart) als Liste anzeigen ...").actionListener(actionEvent -> this.gui.showIAdjectivesInPositivePresenceAsList());
    }

    private JMenuItem createShowNaAdjectivesInPositivePresenceAsListMenuItem() {
        return new MyMenuItem("\u306a-Adjektive in Grundform (positive Gegenwart) als Liste anzeigen ...").actionListener(actionEvent -> this.gui.showNaAdjectivesInPositivePresenceAsList());
    }

    private JMenuItem createShowListOfNaAdjectivesEndingWithIMenuItem() {
        return new MyMenuItem("\u306a-Adjektive die auf \u3044 enden als Liste anzeigen ...").mnemonic('n').actionListener(actionEvent -> this.gui.showListOfNaAdjectivesEndingWithI());
    }

    private JMenuItem createShowListOfIruEruExceptionVerbsMenuItem() {
        return new MyMenuItem("\u3044\u308b/\u3048\u308b-Ausnahme-Verben als Liste anzeigen ...").mnemonic('i').actionListener(actionEvent -> this.gui.showListOfIruEruExceptionVerbs());
    }

    private JMenuItem createCreateVerbOrAdjectiveTablesMenuItem() {
        return new MyMenuItem("Grammatikalische Tabellen von Verben oder Adjektiven erstellen ...").mnemonic('t').accelerator(84, 128).actionListener(actionEvent -> this.gui.createVerbOrAdjectiveTables());
    }
}

