/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.creation.menu;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.common.data.VocabularySortOrder;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class VocabularyMenuCreation
implements SingleMenuCreation {
    private final VocabularyTrainerGui gui;

    public VocabularyMenuCreation(VocabularyTrainerGui vocabularyTrainerGui) {
        this.gui = vocabularyTrainerGui;
    }

    @Override
    public JMenu createTheMenu() {
        JMenu jMenu = new JMenu("Vokabularien");
        jMenu.setMnemonic('a');
        for (VocabularySortOrder vocabularySortOrder : VocabularySortOrder.values()) {
            jMenu.add(this.createVocabularySortOrderMenuItem(vocabularySortOrder));
        }
        jMenu.addSeparator();
        jMenu.add(this.createToggleManualVocabularySortModeMenuItem());
        return jMenu;
    }

    private JMenuItem createVocabularySortOrderMenuItem(VocabularySortOrder vocabularySortOrder) {
        return new MyMenuItem("Vokabularien " + vocabularySortOrder.getDescription() + " sortieren").actionListener(actionEvent -> this.gui.setVocabularySortOrder(vocabularySortOrder));
    }

    private JMenuItem createToggleManualVocabularySortModeMenuItem() {
        return new MyMenuItem("Modus zum individuellen Anordnen der Vokabulaien an- bzw. ausschalten").mnemonic('m').accelerator(113, 0).actionListener(actionEvent -> this.gui.toggleManualVocabularySortMode());
    }
}

