/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.grammar.headers.tools;

import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.vocabulary.japanese.ui.dialog.grammar.headers.data.GrammarFormAndStringSelection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GrammarTableHeaderFieldsToMapCreator {
    private final List<GrammarFormAndStringSelection> formAndSelections;
    private final Map<String, String> grammarTableHeadersMap;
    private boolean success;
    private List<String> problems;

    public GrammarTableHeaderFieldsToMapCreator(List<GrammarFormAndStringSelection> list, Map<String, String> map) {
        this.formAndSelections = list;
        this.grammarTableHeadersMap = map;
    }

    public void create() {
        this.success = true;
        this.problems = new ArrayList<String>();
        for (GrammarFormAndStringSelection grammarFormAndStringSelection : this.formAndSelections) {
            String string = grammarFormAndStringSelection.getGrammarForm();
            StringSelection stringSelection = grammarFormAndStringSelection.getStringSelection();
            String string2 = stringSelection.getTrimmedText();
            if (string2.isBlank() || string2.equals(string)) {
                this.grammarTableHeadersMap.remove(string);
                continue;
            }
            if (string2.contains("##;##")) {
                this.addContainedWrongTextError(string, string2, "##;##");
                continue;
            }
            if (string2.contains("#;#")) {
                this.addContainedWrongTextError(string, string2, "#;#");
                continue;
            }
            this.grammarTableHeadersMap.put(string, string2);
        }
    }

    private void addContainedWrongTextError(String string, String string2, String string3) {
        this.addError("Die vom Benutzer eingegebene Form zu \n" + string + ", n\u00e4mlich\n" + string2 + "\nenth\u00e4lt die unzul\u00e4ssige Zeichenkette '" + string3 + "'.");
    }

    private void addError(String string) {
        this.success = false;
        this.problems.add(string);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public List<String> getProblems() {
        return this.problems;
    }
}

