/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kana.hiraganatest.components;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import de.duehl.vocabulary.japanese.ui.dialog.kana.hiraganatest.components.HiraganaPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class HiraganaDetailDialog
extends ModalDialogBase {
    private static final int MIN_WIDTH = 700;
    private final HiraganaPanel hiraganaPanel;
    private final JButton okButton;

    public HiraganaDetailDialog(Hiragana hiragana, InternalKanaDataRequester internalKanaDataRequester, Point point, Image image) {
        super(point, image, "Details des zu " + hiragana.getCharacter());
        this.addEscapeBehaviour();
        this.hiraganaPanel = new HiraganaPanel();
        this.hiraganaPanel.showHiraganaAsViewerToo();
        this.hiraganaPanel.showInternalHiraganaDataToo(internalKanaDataRequester);
        this.hiraganaPanel.createGui();
        this.hiraganaPanel.showHiragana(hiragana);
        this.okButton = new JButton("Beenden");
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.okButton.addActionListener(actionEvent -> this.closeDialog());
    }

    @Override
    protected void populateDialog() {
        this.add(this.createDummyWidthLabel(), "North");
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        SwingUtilities.invokeLater(() -> this.okButton.requestFocus());
    }

    private Component createDummyWidthLabel() {
        JLabel jLabel = new JLabel("");
        jLabel.setPreferredSize(new Dimension(700, 0));
        return jLabel;
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createTitle(jPanel);
        jPanel.add(this.hiraganaPanel.getPanel());
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.okButton, "East");
        return jPanel;
    }
}

