/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kana.katakanatest;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.data.symbol.KanaSubType;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;
import de.duehl.vocabulary.japanese.logic.symbol.kana.test.data.KatakanaForTestSelectionMethod;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;

public class KatakanaTestParameterChooser
extends ModalDialogBase {
    private static final int MIN_WIDTH = 500;
    private final List<Katakana> notTenTimesGoodTestedKatakanaList;
    private boolean applied;
    private final JCheckBox useOriginalKatakanaOrderCheckBox;
    private final JRadioButton fiveKatakanaRadioButton;
    private final JRadioButton tenKatakanaRadioButton;
    private final JRadioButton fifteenKatakanaRadioButton;
    private final JRadioButton twenytKatakanaRadioButton;
    private final JRadioButton thirtyKatakanaRadioButton;
    private final JRadioButton fiftyKatakanaRadioButton;
    private final JRadioButton allKatakanaRadioButton;
    private final JRadioButton notTenTimesGoodTestedKatakanaRadioButton;
    private final JRadioButton lastThirtyKatakanaRadioButton;
    private final JRadioButton lastTwentyKatakanaRadioButton;
    private final JRadioButton lastFifteenKatakanaRadioButton;
    private final JRadioButton lastTenKatakanaRadioButton;
    private final JRadioButton lastFiveKatakanaRadioButton;
    private final List<JCheckBox> subTypCheckboxes;
    private final Map<JCheckBox, KanaSubType> subTypeCheckBoxToType;
    private final JButton okButton;
    private int numberOfKatakanaToTest;
    private boolean useOriginalKatakanaOrder;
    private KatakanaForTestSelectionMethod selectionMethod;
    private List<Katakana> katakanaList;

    public KatakanaTestParameterChooser(List<Katakana> list, Point point, Image image) {
        super(point, image, "Die Parameter f\u00fcr den Katakana-Test ausw\u00e4hlen");
        this.notTenTimesGoodTestedKatakanaList = list;
        this.useOriginalKatakanaOrderCheckBox = new JCheckBox("in Originalreihenfolge");
        this.fiveKatakanaRadioButton = new JRadioButton("5 Katakana");
        this.tenKatakanaRadioButton = new JRadioButton("10 Katakana");
        this.fifteenKatakanaRadioButton = new JRadioButton("15 Katakana");
        this.twenytKatakanaRadioButton = new JRadioButton("20 Katakana");
        this.thirtyKatakanaRadioButton = new JRadioButton("30 Katakana");
        this.fiftyKatakanaRadioButton = new JRadioButton("50 Katakana");
        this.allKatakanaRadioButton = new JRadioButton("Alle Katakana (" + NumberString.taupu(Katakana.getNumberOfKnownKatakana()) + ")");
        this.notTenTimesGoodTestedKatakanaRadioButton = new JRadioButton("nicht zuletzt zehn mal richtig abgefragte Katakana");
        this.lastThirtyKatakanaRadioButton = new JRadioButton("die letzten 30 Katakana");
        this.lastTwentyKatakanaRadioButton = new JRadioButton("die letzten 20 Katakana");
        this.lastFifteenKatakanaRadioButton = new JRadioButton("die letzten 15 Katakana");
        this.lastTenKatakanaRadioButton = new JRadioButton("die letzten 10 Katakana");
        this.lastFiveKatakanaRadioButton = new JRadioButton("die letzten 5 Katakana");
        this.subTypCheckboxes = new ArrayList<JCheckBox>();
        this.subTypeCheckBoxToType = new HashMap<JCheckBox, KanaSubType>();
        this.okButton = new JButton();
        this.selectionMethod = KatakanaForTestSelectionMethod.UNKNOWN;
        this.applied = false;
        this.init();
        this.fillDialog();
    }

    private void init() {
        this.initRadioButtons();
        this.initCheckBoxes();
        this.initSubTypeCheckBoxes();
        this.addSubTypeCheckBoxesActionListener();
        this.subTypesSelectionChanged();
    }

    private void initRadioButtons() {
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.fiveKatakanaRadioButton);
        buttonGroup.add(this.tenKatakanaRadioButton);
        buttonGroup.add(this.fifteenKatakanaRadioButton);
        buttonGroup.add(this.twenytKatakanaRadioButton);
        buttonGroup.add(this.thirtyKatakanaRadioButton);
        buttonGroup.add(this.fiftyKatakanaRadioButton);
        buttonGroup.add(this.allKatakanaRadioButton);
        buttonGroup.add(this.notTenTimesGoodTestedKatakanaRadioButton);
        buttonGroup.add(this.lastThirtyKatakanaRadioButton);
        buttonGroup.add(this.lastTwentyKatakanaRadioButton);
        buttonGroup.add(this.lastFifteenKatakanaRadioButton);
        buttonGroup.add(this.lastTenKatakanaRadioButton);
        buttonGroup.add(this.lastFiveKatakanaRadioButton);
        this.allKatakanaRadioButton.setSelected(true);
    }

    private void initCheckBoxes() {
        this.useOriginalKatakanaOrderCheckBox.setSelected(false);
    }

    private void initSubTypeCheckBoxes() {
        for (KanaSubType kanaSubType : KanaSubType.values()) {
            JCheckBox jCheckBox = new JCheckBox(kanaSubType.getDescription());
            jCheckBox.setSelected(kanaSubType == KanaSubType.STANDARD || kanaSubType == KanaSubType.WITH_DAKUTEN || kanaSubType == KanaSubType.WITH_HANDAKUTEN || kanaSubType == KanaSubType.COMPOUND || kanaSubType == KanaSubType.COMPOUND_WITH_DAKUTEN || kanaSubType == KanaSubType.COMPOUND_WITH_HANDAKUTEN);
            this.subTypCheckboxes.add(jCheckBox);
            this.subTypeCheckBoxToType.put(jCheckBox, kanaSubType);
        }
    }

    private void addSubTypeCheckBoxesActionListener() {
        for (JCheckBox jCheckBox : this.subTypCheckboxes) {
            jCheckBox.addActionListener(actionEvent -> this.subTypesSelectionChanged());
        }
    }

    private void subTypesSelectionChanged() {
        List<Katakana> list = this.createKatakanaListWithSelecetdSubtypes();
        int n = list.size();
        this.allKatakanaRadioButton.setText("Alle Katakana (" + NumberString.taupu(n) + ")");
        int n2 = this.notTenTimesGoodTestedKatakanaList.size();
        this.notTenTimesGoodTestedKatakanaRadioButton.setText("nicht zuletzt zehn mal richtig abgefragte Katakana (" + n2 + ")");
        this.notTenTimesGoodTestedKatakanaRadioButton.setEnabled(!this.notTenTimesGoodTestedKatakanaList.isEmpty());
        this.handleRadioButton(this.fiveKatakanaRadioButton, 5, n);
        this.handleRadioButton(this.tenKatakanaRadioButton, 10, n);
        this.handleRadioButton(this.fifteenKatakanaRadioButton, 15, n);
        this.handleRadioButton(this.twenytKatakanaRadioButton, 20, n);
        this.handleRadioButton(this.thirtyKatakanaRadioButton, 30, n);
        this.handleRadioButton(this.fiftyKatakanaRadioButton, 50, n);
        this.handleRadioButton(this.lastThirtyKatakanaRadioButton, 30, n);
        this.handleRadioButton(this.lastTwentyKatakanaRadioButton, 20, n);
        this.handleRadioButton(this.lastFifteenKatakanaRadioButton, 15, n);
        this.handleRadioButton(this.lastTenKatakanaRadioButton, 10, n);
        this.handleRadioButton(this.lastFiveKatakanaRadioButton, 5, n);
    }

    private void handleRadioButton(JRadioButton jRadioButton, int n, int n2) {
        jRadioButton.setEnabled(n2 >= n);
        if (n2 < n && jRadioButton.isSelected()) {
            jRadioButton.setSelected(false);
        }
    }

    @Override
    protected void populateDialog() {
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        SwingUtilities.invokeLater(() -> this.okButton.requestFocus());
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createKatakanaSubTypeSelectionPart(), "North");
        jPanel.add(this.createNumberOfKatakanaPart(), "Center");
        jPanel.add(this.createSortKatakanaPart(), "South");
        return jPanel;
    }

    private Component createKatakanaSubTypeSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createTitle("Unterarten", jPanel);
        for (JCheckBox jCheckBox : this.subTypCheckboxes) {
            jPanel.add(jCheckBox);
        }
        return jPanel;
    }

    private Component createNumberOfKatakanaPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.createNumberOfRandomSelectedKatakanaPart());
        jPanel.add(this.createNumberOfLastXKatakanaPart());
        jPanel.add(this.createNumberOfAllKatakanaPart());
        jPanel.add(this.createNumberOfNotTenTimesGoodTestedKatakanaPart());
        jPanel.add(this.createDummyMinWidthLabelPart());
        return jPanel;
    }

    private Component createNumberOfRandomSelectedKatakanaPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("F\u00fcr die Abfrage der Katakana die folgende Anzahl zuf\u00e4llig ausgew\u00e4hen", jPanel);
        jPanel.add(this.fiveKatakanaRadioButton);
        jPanel.add(this.tenKatakanaRadioButton);
        jPanel.add(this.fifteenKatakanaRadioButton);
        jPanel.add(this.twenytKatakanaRadioButton);
        jPanel.add(this.thirtyKatakanaRadioButton);
        jPanel.add(this.fiftyKatakanaRadioButton);
        return jPanel;
    }

    private Component createNumberOfLastXKatakanaPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("F\u00fcr die Abfrage der Katakana die folgende Anzahl der zuletzt hinzugef\u00fcgten ausgew\u00e4hen", jPanel);
        jPanel.add(this.lastThirtyKatakanaRadioButton);
        jPanel.add(this.lastTwentyKatakanaRadioButton);
        jPanel.add(this.lastFifteenKatakanaRadioButton);
        jPanel.add(this.lastTenKatakanaRadioButton);
        jPanel.add(this.lastFiveKatakanaRadioButton);
        return jPanel;
    }

    private Component createNumberOfAllKatakanaPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("Alle Katakana abfragen", jPanel);
        jPanel.add(this.allKatakanaRadioButton);
        return jPanel;
    }

    private Component createNumberOfNotTenTimesGoodTestedKatakanaPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(0, 3, 5, 5));
        GuiTools.createTitle("Nicht zehn mal richtig beantwortete Katakana abfragen", jPanel);
        jPanel.add(this.notTenTimesGoodTestedKatakanaRadioButton);
        return jPanel;
    }

    private Component createDummyMinWidthLabelPart() {
        JLabel jLabel = new JLabel("");
        jLabel.setPreferredSize(new Dimension(500, 0));
        return jLabel;
    }

    private Component createSortKatakanaPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle("Sortierung", jPanel);
        jPanel.add((Component)this.useOriginalKatakanaOrderCheckBox, "Center");
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "West");
        jPanel.add(this.createOkButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Abbrechen");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.closeDialog();
    }

    private Component createOkButton() {
        this.okButton.setText("   Abfrage starten   ");
        GuiTools.biggerFont(this.okButton, 5);
        this.okButton.addActionListener(actionEvent -> this.apply());
        return this.okButton;
    }

    private List<Katakana> createKatakanaListWithSelecetdSubtypes() {
        ArrayList<KanaSubType> arrayList = new ArrayList<KanaSubType>();
        for (JCheckBox katakanaArray : this.subTypCheckboxes) {
            if (!katakanaArray.isSelected()) continue;
            if (!this.subTypeCheckBoxToType.containsKey(katakanaArray)) {
                throw new RuntimeException("Zur subTypeCheckBox '" + katakanaArray.getText() + "' ist der Typ nicht bekannt!");
            }
            KanaSubType kanaSubType = this.subTypeCheckBoxToType.get(katakanaArray);
            if (arrayList.contains((Object)kanaSubType)) continue;
            arrayList.add(kanaSubType);
        }
        ArrayList arrayList2 = new ArrayList();
        for (Katakana katakana : Katakana.values()) {
            KanaSubType kanaSubType = katakana.getSubType();
            if (!arrayList.contains((Object)kanaSubType)) continue;
            arrayList2.add(katakana);
        }
        return arrayList2;
    }

    private void apply() {
        this.katakanaList = this.createKatakanaListWithSelecetdSubtypes();
        if (this.fiveKatakanaRadioButton.isSelected()) {
            this.numberOfKatakanaToTest = 5;
            this.selectionMethod = KatakanaForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.tenKatakanaRadioButton.isSelected()) {
            this.numberOfKatakanaToTest = 10;
            this.selectionMethod = KatakanaForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.fifteenKatakanaRadioButton.isSelected()) {
            this.numberOfKatakanaToTest = 15;
            this.selectionMethod = KatakanaForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.twenytKatakanaRadioButton.isSelected()) {
            this.numberOfKatakanaToTest = 20;
            this.selectionMethod = KatakanaForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.thirtyKatakanaRadioButton.isSelected()) {
            this.numberOfKatakanaToTest = 30;
            this.selectionMethod = KatakanaForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.fiftyKatakanaRadioButton.isSelected()) {
            this.numberOfKatakanaToTest = 50;
            this.selectionMethod = KatakanaForTestSelectionMethod.RANDOM_BY_NUMBER;
        } else if (this.allKatakanaRadioButton.isSelected()) {
            this.numberOfKatakanaToTest = Katakana.getNumberOfKnownKatakana();
            this.selectionMethod = KatakanaForTestSelectionMethod.ALL;
        } else if (this.notTenTimesGoodTestedKatakanaRadioButton.isSelected()) {
            this.numberOfKatakanaToTest = this.notTenTimesGoodTestedKatakanaList.size();
            this.selectionMethod = KatakanaForTestSelectionMethod.NOT_TEN_TIMES_GOOD_TESTED;
        } else if (this.lastThirtyKatakanaRadioButton.isSelected()) {
            this.numberOfKatakanaToTest = 30;
            this.selectionMethod = KatakanaForTestSelectionMethod.LAST_N;
        } else if (this.lastTwentyKatakanaRadioButton.isSelected()) {
            this.numberOfKatakanaToTest = 20;
            this.selectionMethod = KatakanaForTestSelectionMethod.LAST_N;
        } else if (this.lastFifteenKatakanaRadioButton.isSelected()) {
            this.numberOfKatakanaToTest = 15;
            this.selectionMethod = KatakanaForTestSelectionMethod.LAST_N;
        } else if (this.lastTenKatakanaRadioButton.isSelected()) {
            this.numberOfKatakanaToTest = 10;
            this.selectionMethod = KatakanaForTestSelectionMethod.LAST_N;
        } else if (this.lastFiveKatakanaRadioButton.isSelected()) {
            this.numberOfKatakanaToTest = 5;
            this.selectionMethod = KatakanaForTestSelectionMethod.LAST_N;
        } else {
            this.numberOfKatakanaToTest = -1;
            this.selectionMethod = KatakanaForTestSelectionMethod.UNKNOWN;
            String string = "Keine Anzahl an Katakana ausgew\u00e4hlt";
            String string2 = "Sie haben die Anzahl der abzufragenden Katakana nicht ausgew\u00e4hlt.";
            GuiTools.informUser(this.getWindowAsComponent(), string, string2);
            return;
        }
        this.useOriginalKatakanaOrder = this.useOriginalKatakanaOrderCheckBox.isSelected();
        this.applied = true;
        this.quit();
    }

    public boolean isApplied() {
        return this.applied;
    }

    public List<Katakana> getKatakanaList() {
        return this.katakanaList;
    }

    public int getNumberOfKatakanaToTest() {
        return this.numberOfKatakanaToTest;
    }

    public boolean isUseOriginalKatakanaOrder() {
        return this.useOriginalKatakanaOrder;
    }

    public KatakanaForTestSelectionMethod getSelectionMethod() {
        return this.selectionMethod;
    }
}

