/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.components.selections.SelectionsHelper;
import de.duehl.swing.ui.components.selections.StringSelection;
import de.duehl.swing.ui.components.selections.TextAreaSelection;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.swing.ui.key.BindKeysOnRootPane;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.vocabulary.japanese.common.color.VocableColors;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.test.data.KanjiUserInputType;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.test.data.SingleUserInputKanjiCheckResult;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.display.KanjiPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class KanjiTestEvaluationDialog
extends ModalDialogBase {
    private static final int MIN_WIDTH = 700;
    private final SingleUserInputKanjiCheckResult result;
    private final Kanji kanji;
    private final boolean correct;
    private final FumikoDataStructures dataStructures;
    private final String message;
    private final VocableColors vocableColors;
    private final Color backgroundColor;
    private final KanjiPanel kanjiPanel;
    private final JButton quitButton;
    private boolean onlyTypingError;
    private final StringSelection userInputGermanMeaningSelection;
    private final StringSelection userInputOnLesungenSelection;
    private final StringSelection userInputKunLesungenSelection;
    private final TextAreaSelection errorMessageSelection;
    private final TextAreaSelection memorandumSelection;
    private boolean errorFilled;
    private boolean memorandumFilled;

    public KanjiTestEvaluationDialog(SingleUserInputKanjiCheckResult singleUserInputKanjiCheckResult, String string, String string2, String string3, FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, Point point) {
        super(point, fumikoUiObjects.getProgramImage(), singleUserInputKanjiCheckResult.isOk() ? "Richtig!" : "Leider falsch");
        this.addEscapeBehaviour();
        this.result = singleUserInputKanjiCheckResult;
        this.kanji = singleUserInputKanjiCheckResult.getKanji();
        this.correct = singleUserInputKanjiCheckResult.isOk();
        this.dataStructures = fumikoDataStructures;
        this.onlyTypingError = false;
        this.message = this.correct ? "Richtig beantwortet, sehr gut!" : "Das war leider nicht richtig";
        this.vocableColors = new VocableColors(fumikoDataStructures.getOptions());
        this.backgroundColor = this.correct ? this.vocableColors.getSuccessColor() : this.vocableColors.getFailureColor();
        this.quitButton = new JButton("Beenden");
        this.kanjiPanel = new KanjiPanel(this.kanji, this.getWindowAsComponent());
        this.userInputGermanMeaningSelection = new StringSelection("Eingebene deutsche Bedeutung");
        this.userInputOnLesungenSelection = new StringSelection("Eingebene ON-Lesungen");
        this.userInputKunLesungenSelection = new StringSelection("Eingebene kun-Lesungen");
        this.errorMessageSelection = new TextAreaSelection("Fehlermeldungen");
        this.memorandumSelection = new TextAreaSelection("Hinweise");
        this.init(string, string2, string3);
        this.fillDialog();
    }

    private void init(String string, String string2, String string3) {
        this.initKanjiPanel();
        this.fillKanjiPanel();
        this.initUserInputTextSelections();
        this.fillUserInputTextSelections(string, string2, string3);
        this.initResultTextSelections();
        this.fillResultTextSelections();
        this.initQuitButton();
    }

    private void initKanjiPanel() {
        this.kanjiPanel.createGui();
    }

    private void fillKanjiPanel() {
        this.kanjiPanel.showKanji();
    }

    private void initUserInputTextSelections() {
        SelectionsHelper.initSelectionAsViewer(this.userInputGermanMeaningSelection);
        SelectionsHelper.initSelectionAsViewer(this.userInputOnLesungenSelection);
        SelectionsHelper.initSelectionAsViewer(this.userInputKunLesungenSelection);
        Options options = this.dataStructures.getOptions();
        if (options.isColorUserInputAtKanjiTestEvaluationDialog()) {
            this.setUserInputTextSelectionsBackgrounds();
        }
    }

    private void setUserInputTextSelectionsBackgrounds() {
        List<KanjiUserInputType> list = this.result.getWrongKanjiUserInputTypes();
        boolean bl = !list.contains((Object)KanjiUserInputType.GERMAN_MEANING);
        boolean bl2 = !list.contains((Object)KanjiUserInputType.ON_LESUNG);
        boolean bl3 = !list.contains((Object)KanjiUserInputType.KUN_LESUNG);
        Color color = this.getSuccessOrFailureColor(bl);
        Color color2 = this.getSuccessOrFailureColor(bl2);
        Color color3 = this.getSuccessOrFailureColor(bl3);
        this.userInputGermanMeaningSelection.setBackgroundColor(color);
        this.userInputOnLesungenSelection.setBackgroundColor(color2);
        this.userInputKunLesungenSelection.setBackgroundColor(color3);
    }

    private Color getSuccessOrFailureColor(boolean bl) {
        if (bl) {
            return this.vocableColors.getSuccessColor();
        }
        return this.vocableColors.getFailureColor();
    }

    private void fillUserInputTextSelections(String string, String string2, String string3) {
        this.userInputGermanMeaningSelection.setText(string);
        this.userInputOnLesungenSelection.setText(string2);
        this.userInputKunLesungenSelection.setText(string3);
    }

    private void initResultTextSelections() {
        SelectionsHelper.initSelectionAsViewer(this.errorMessageSelection);
        SelectionsHelper.initSelectionAsViewer(this.memorandumSelection);
    }

    private void fillResultTextSelections() {
        String string = this.result.getErrorDescription();
        String string2 = this.result.getMemorandum();
        this.errorMessageSelection.setText(string);
        this.memorandumSelection.setText(string2);
        this.errorFilled = !string.isBlank();
        this.memorandumFilled = !string2.isBlank();
    }

    private void initQuitButton() {
        GuiTools.addReturnListener(this.quitButton, () -> this.quitButton.doClick());
    }

    @Override
    protected void populateDialog() {
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        if (!this.correct) {
            this.keybindingsForOnlyTypingError();
        }
        SwingUtilities.invokeLater(() -> this.quitButton.requestFocus());
        this.pack();
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        jPanel.add(this.createMessagePart());
        jPanel.add(this.createKanjiDataPart());
        jPanel.add(this.createUserDataPart());
        if (this.errorFilled || this.memorandumFilled) {
            jPanel.add(this.createErrorMesageAndMemorandumPart());
        }
        if (!this.correct) {
            jPanel.add(this.createOnlyTypingErrorLabel());
        }
        return GuiTools.createScrollPane(jPanel);
    }

    private Component createMessagePart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        GuiTools.createTitle(jPanel);
        jPanel.add(this.createMessageLabel(), "Center");
        return jPanel;
    }

    private Component createMessageLabel() {
        JLabel jLabel = new JLabel(this.message);
        jLabel.setHorizontalAlignment(0);
        jLabel.setPreferredSize(new Dimension(700, 30));
        GuiTools.biggerFont(jLabel, 7);
        jLabel.setOpaque(true);
        jLabel.setBackground(this.backgroundColor);
        return jLabel;
    }

    private Component createKanjiDataPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createBlueTitle("Daten zum abgefragten Kanji:", jPanel);
        jPanel.add(this.kanjiPanel.getPanel());
        return jPanel;
    }

    private Component createUserDataPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createBlueTitle("Vom Benutzer eingegebene Daten:", jPanel);
        jPanel.add(this.userInputGermanMeaningSelection.getPanel());
        jPanel.add(this.userInputOnLesungenSelection.getPanel());
        jPanel.add(this.userInputKunLesungenSelection.getPanel());
        return jPanel;
    }

    private Component createErrorMesageAndMemorandumPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(0, 3));
        GuiTools.createBlueTitle("Fehler und Hinweise:", jPanel);
        if (this.errorFilled) {
            jPanel.add(this.errorMessageSelection.getPanel());
        }
        if (this.memorandumFilled) {
            jPanel.add(this.memorandumSelection.getPanel());
        }
        return jPanel;
    }

    private Component createOnlyTypingErrorLabel() {
        JLabel jLabel = new JLabel("War es nur ein Tippfehler? Dann Strg-Shift-K dr\u00fccken.");
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        return jLabel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createQuitButton() {
        this.quitButton.addActionListener(actionEvent -> this.closeDialog());
        this.quitButton.setBackground(this.backgroundColor);
        return this.quitButton;
    }

    private void keybindingsForOnlyTypingError() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(75, 192);
        String string = "Strg-Shift-K";
        AbstractAction abstractAction = BindKeysOnRootPane.runnableToAction(() -> this.setToOnlyTypingError());
        JRootPane jRootPane = this.getRootPane();
        InputMap inputMap = jRootPane.getInputMap(2);
        inputMap.put(keyStroke, string);
        jRootPane.getActionMap().put(string, abstractAction);
    }

    private void setToOnlyTypingError() {
        String string = "War es nur ein Tippfehler?";
        String string2 = "War die falsche Eingabe wirklich nur ein Tippfehler?\nBitte gewissenhaft antworten und sich nicht selbst bel\u00fcgen.";
        this.onlyTypingError = GuiTools.askUser(this.getWindowAsComponent(), string, string2);
        if (this.onlyTypingError) {
            this.closeDialog();
        }
    }

    public boolean wasOnlyTypingError() {
        return this.onlyTypingError;
    }
}

