/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.website.update.ownlists;

import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.website.update.UpdateTools;
import de.duehl.vocabulary.japanese.data.FumikoDataStructures;
import de.duehl.vocabulary.japanese.ui.data.FumikoUiObjects;
import de.duehl.vocabulary.japanese.website.download.NewestOwnListVersionListDownloader;
import de.duehl.vocabulary.japanese.website.update.ownlists.GroupsDownloader;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.NewestOwnListVersionListEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.OwnListInterestAndVersionEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.interest.OwnListVersionAndInterestIo;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class OwnListGroupsUpdater {
    public static final OwnListInterestAndVersionEntry NOT_FOUND_INTEREST_AND_VERSION = new OwnListInterestAndVersionEntry("####NICHT GEFUNDEN###", false, -1);
    private final FumikoDataStructures dataStructures;
    private final FumikoUiObjects uiObjects;
    private final boolean checkingNewVersionsOnStartUp;
    private List<NewestOwnListVersionListEntry> newestOwnListVersionEntries;
    private List<OwnListInterestAndVersionEntry> interestAndVersionEntries;
    private List<String> newerOrUnseenGroupNames;

    public OwnListGroupsUpdater(FumikoDataStructures fumikoDataStructures, FumikoUiObjects fumikoUiObjects, boolean bl) {
        this.dataStructures = fumikoDataStructures;
        this.uiObjects = fumikoUiObjects;
        this.checkingNewVersionsOnStartUp = bl;
    }

    public void update() {
        this.newestOwnListVersionEntries = NewestOwnListVersionListDownloader.download();
        if (this.newestOwnListVersionEntries.isEmpty()) {
            if (!this.checkingNewVersionsOnStartUp) {
                UpdateTools.informUserAboutDownloadFailure("der eigenen Listen", this.uiObjects.getGuiLocation(), this.uiObjects.getProgramImage());
            }
        } else {
            this.checkOwnListVersionsAgainstWebsiteVersions();
        }
    }

    private void checkOwnListVersionsAgainstWebsiteVersions() {
        this.interestAndVersionEntries = OwnListVersionAndInterestIo.loadOwnListVersionAndInterests();
        this.newerOrUnseenGroupNames = this.determineNewerVersionsOrUnknownGroupsOnTheServer();
        if (this.newerOrUnseenGroupNames.isEmpty()) {
            if (!this.checkingNewVersionsOnStartUp) {
                this.informUserAboutOwnListsAreActual();
            }
        } else {
            this.updateNewerOwnListVersionAndInterestEntries();
            this.storeInterestAndVersionFile();
            if (this.isUserInterestedInChanges()) {
                this.showOwnListInterestSelectionAndDownloadDialog();
            } else if (!this.checkingNewVersionsOnStartUp) {
                this.informUserAboutOwnListsAreActual();
            }
        }
    }

    private List<String> determineNewerVersionsOrUnknownGroupsOnTheServer() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (NewestOwnListVersionListEntry newestOwnListVersionListEntry : this.newestOwnListVersionEntries) {
            String string = newestOwnListVersionListEntry.getGroupName();
            OwnListInterestAndVersionEntry ownListInterestAndVersionEntry = this.findOwnListInterestAndVersionEntryByGroupname(string);
            if (NOT_FOUND_INTEREST_AND_VERSION.equals(ownListInterestAndVersionEntry)) {
                arrayList.add(string);
                continue;
            }
            int n = ownListInterestAndVersionEntry.getVersion();
            if (n >= newestOwnListVersionListEntry.getVersion()) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private OwnListInterestAndVersionEntry findOwnListInterestAndVersionEntryByGroupname(String string) {
        return OwnListGroupsUpdater.findOwnListInterestAndVersionEntryByGroupname(string, this.interestAndVersionEntries);
    }

    public static OwnListInterestAndVersionEntry findOwnListInterestAndVersionEntryByGroupname(String string, List<OwnListInterestAndVersionEntry> list) {
        for (OwnListInterestAndVersionEntry ownListInterestAndVersionEntry : list) {
            if (!ownListInterestAndVersionEntry.getGroupName().equals(string)) continue;
            return ownListInterestAndVersionEntry;
        }
        return NOT_FOUND_INTEREST_AND_VERSION;
    }

    private void informUserAboutOwnListsAreActual() {
        String string;
        String string2 = string = "Es gibt keine Neuerungen bei den Gruppen mit eigenen Listen";
        GuiTools.informUserInEdt(this.uiObjects.getWindowAsComponent(), string, string2);
    }

    private void updateNewerOwnListVersionAndInterestEntries() {
        ArrayList<OwnListInterestAndVersionEntry> arrayList = new ArrayList<OwnListInterestAndVersionEntry>();
        for (NewestOwnListVersionListEntry newestOwnListVersionListEntry : this.newestOwnListVersionEntries) {
            String string = newestOwnListVersionListEntry.getGroupName();
            OwnListInterestAndVersionEntry ownListInterestAndVersionEntry = this.findOwnListInterestAndVersionEntryByGroupname(string);
            ownListInterestAndVersionEntry = NOT_FOUND_INTEREST_AND_VERSION.equals(ownListInterestAndVersionEntry) ? new OwnListInterestAndVersionEntry(string, true, newestOwnListVersionListEntry.getVersion()) : new OwnListInterestAndVersionEntry(string, ownListInterestAndVersionEntry.isInterested(), newestOwnListVersionListEntry.getVersion());
            arrayList.add(ownListInterestAndVersionEntry);
        }
        this.interestAndVersionEntries = arrayList;
    }

    private void storeInterestAndVersionFile() {
        OwnListVersionAndInterestIo.storeInterestAndVersionFile(this.interestAndVersionEntries);
    }

    private boolean isUserInterestedInChanges() {
        for (String string : this.newerOrUnseenGroupNames) {
            OwnListInterestAndVersionEntry ownListInterestAndVersionEntry = this.findOwnListInterestAndVersionEntryByGroupname(string);
            if (NOT_FOUND_INTEREST_AND_VERSION.equals(ownListInterestAndVersionEntry) || !ownListInterestAndVersionEntry.isInterested()) continue;
            return true;
        }
        return false;
    }

    private void showOwnListInterestSelectionAndDownloadDialog() {
        SwingUtilities.invokeLater(() -> this.showOwnListInterestSelectionAndDownloadDialogInEdt());
    }

    private void showOwnListInterestSelectionAndDownloadDialogInEdt() {
        GroupsDownloader groupsDownloader = new GroupsDownloader(this.dataStructures, this.uiObjects, this.newestOwnListVersionEntries, this.interestAndVersionEntries, this.newerOrUnseenGroupNames);
        groupsDownloader.download();
    }
}

