/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.website.update.program;

import de.duehl.basics.version.Version;
import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.website.update.UpdateTools;
import de.duehl.vocabulary.japanese.common.website.update.program.ProgramUpdaterTools;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;

public class ProgramUpdatableChecker {
    private final String versionNumberRunning;
    private final Component guiComponent;
    private final Point parentLocation;
    private final Image programImage;

    public ProgramUpdatableChecker(String string, Component component, Point point, Image image) {
        this.versionNumberRunning = string;
        this.guiComponent = component;
        this.parentLocation = point;
        this.programImage = image;
    }

    public void update() {
        String string = ProgramUpdaterTools.downloadProgramVersionFromServer();
        if (string.equals("Kein Erfolg beim Download!")) {
            UpdateTools.informUserAboutDownloadFailure("des Programms", this.parentLocation, this.programImage);
        } else {
            Version version = new Version(string, "interessiert nicht");
            Version version2 = new Version(this.versionNumberRunning, "interessiert nicht");
            if (version.isNewerThan(version2)) {
                this.informUserAboutNewerProgramVersion(this.versionNumberRunning, string);
            } else {
                this.informUserAboutProgramVersionIsActual(this.versionNumberRunning);
            }
        }
    }

    private void informUserAboutNewerProgramVersion(String string, String string2) {
        String string3 = "Es gibt eine neuere Programmversion";
        String string4 = "Es gibt eine neuere Programmversion!\n\nAktuelle Programmversion: " + string + "\nNeuere Programmversion: " + string2 + "\n\nBitte beenden sie den Trainer und starten Sie den Launcher, um die neue Version herunterzuladen.\nDaf\u00fcr muss das Programm nur neu getsartet werden, dabei startet zuerst der Launcher und anschlie\u00dfend der Vokabeltrainer.";
        GuiTools.informUserInEdt(string3, string4);
    }

    private void informUserAboutProgramVersionIsActual(String string) {
        String string2 = "Der Vokabeltrainer ist aktuell";
        String string3 = "Die verwendete Programmversion " + string + " ist aktuell.";
        GuiTools.informUserInEdt(this.guiComponent, string2, string3);
    }
}

