package de.duehl.basics.autodetect.ent;

/**
 * Diese Klasse ist die abstrakte Basis einer Klasse, welche einen Text (ent) bearbeitet und
 * dabei einen Fehler werfen kann.
 *
 * Es werden Kommentare zur Auffindung des Begriffs gesammelt.
 *
 * @version 1.01     2022-05-06
 * @author Christian Dühl
 */

public abstract class SimpleEntWorkerWithFailure extends SimpleEntWorker {

    /** Beinhaltet den Grund eines ggf. auftretenden Fehlers. */
    private String failure;

    /**
     * Konstruktor.
     *
     * @param ent
     *            Ursprünglich der rohe Text, dieser wird/wurde bei der Analyse aber verändert und
     *            Teile durch die Entitäten wie <<street>> oder <<street:2>> ersetzt.
     */
    public SimpleEntWorkerWithFailure(String ent) {
        super(ent);
        failure = "";
    }

    /** Setzt den Fehlertext. */
    protected final void setFailure(String failure) {
        this.failure = failure;
    }

    /** Gibt an, ob ein Fehler aufgetreten ist. */
    public final boolean didFailureOccure() {
        return !failure.isEmpty();
    }

    /** Gibt den Fehlertext zurück. Ist leer, wenn kein Fehler auftrat. */
    public final String getFailure() {
        return failure;
    }

}
