package de.duehl.basics.io.data;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse beinhaltet den Eingabe- und Ausgabenamen zu einer zu bearbeitenden Datei.
 *
 * @version 1.01     2016-02-26
 * @author Christian Dühl
 */

public class InputOutput {

    /** Name der Eingabedatei. */
    private final String input;

    /** Name der Ausgabedatei. */
    private final String output;

    /**
     * Konstruktor.
     *
     * @param input
     *            Name der Eingabedatei.
     * @param output
     *            Name der Ausgabedatei.
     */
    public InputOutput(String input, String output) {
        this.input = input;
        this.output = output;
    }

    /** Getter für den Namen der Eingabedatei. */
    public String getInput() {
        return input;
    }

    /** Getter für den Namen der Ausgabedatei. */
    public String getOutput() {
        return output;
    }

    /** Stringrepräsentation erzeugen. */
    @Override
    public String toString() {
        return "InputOutput [input=" + input + ", output=" + output + "]";
    }

}
