package de.duehl.basics.java.data;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Enum-Klasse steht für den Zustand in dem sich die Analyse befindet.
 *
 * @version 1.03     2025-11-28
 * @author Christian Dühl
 */

public enum EnumAnalyseState {

    FIRST_NOT_FOUND,                      // Bevor die erste Definition gefunden wurde.
    DEFINITION_STARTED_BUT_NOT_CLOSED,    // Eine Definition hat(zuvor) angefangen aber das Ende
                                          // wurde noch nicht erreicht, da sie über mehrere Zeilen
                                          // geht.
    DEFINITION_CLOSED,                    // Nachdem eine Definition geschlossen wurde.
    ALL_DEFINITIONS_CLOSED,               // Wenn keine weiteren Definitionen mehr kommen.
    ;

}
