package de.duehl.basics.java.data;

/*
 * Copyright 2025 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse steht für eine Enum-Defnition aus dem eingelesenen Quellcode einer (meiner!)
 * Enum-Klassen.
 *
 * @version 1.03     2025-11-28
 * @author Christian Dühl
 */

public class EnumDefinition {

    /** Die Definition (z.B. "FISCH"). */
    private final String definition;

    /**
     * Der Inhalt der Klammer hinter der Definition (z.B.
     *     "魚", "Fisch", "魚", "さかな", 290, 112, CollectionsHelper.buildListFrom("GYO"),
     *     CollectionsHelper.buildListFrom("sakana", "uo")
     * ).
     *
     * Wird passend zusammengesetzt, wenn er über mehrere Zeilen geht, so dass keine Zeilenumbrüche
     * darin sind.
     */
    private final String braceContent;

    /**
     * Konstruktor.
     *
     * @param definition
     *            Die Definition.
     * @param braceContent
     *            Der Inhalt der Klammer hinter der Definition.
     */
    public EnumDefinition(String definition, String braceContent) {
        this.definition = definition;
        this.braceContent = braceContent;
    }

    /** Getter für die Definition (z.B. "FISCH"). */
    public String getDefinition() {
        return definition;
    }

    /**
     * Getter für den Inhalt der Klammer hinter der Definition (z.B.
     *     "魚", "Fisch", "魚", "さかな", 290, 112, CollectionsHelper.buildListFrom("GYO"),
     *     CollectionsHelper.buildListFrom("sakana", "uo")
     * ).
     *
     * Wird passend zusammengesetzt, wenn er über mehrere Zeilen geht, so dass keine Zeilenumbrüche
     * darin sind.
     */
    public String getBraceContent() {
        return braceContent;
    }

    @Override
    public String toString() {
        return "EnumDefinition [definition=" + definition + ", braceContent=" + braceContent + "]";
    }

}
