package de.duehl.basics.logging;

/**
 * Dieses Klasse dient zum Loggen in eine Haupt- und eine Nebendatei.
 *
 * @version 1.01     2017-06-01
 * @author Christian Dühl
 */

public class DoubleFileLogger implements Logger {

    private Logger mainLogger;
    private Logger sideLogger;

    public DoubleFileLogger(Logger mainLogger, String sideLogFile) {
        this.mainLogger = mainLogger;

        FileLogger sideLogger = new FileLogger(sideLogFile);
        sideLogger.logTitle();

        this.sideLogger = sideLogger;
    }

    @Override
    public void log(String text) {
        mainLogger.log(text, 1);
        sideLogger.log(text, 1);
    }

    @Override
    public void log(String text, int stacktraceOffset) {
        mainLogger.log(text, stacktraceOffset + 1);
        sideLogger.log(text, stacktraceOffset + 1);
    }

    @Override
    public String getLogFileName() {
        return mainLogger.getLogFileName();
    }

    @Override
    public String getLogPath() {
        return mainLogger.getLogPath();
    }

    @Override
    public int getLastWrittenLineNumber() {
        return mainLogger.getLastWrittenLineNumber();
    }

}
