package de.duehl.basics.logging;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Klasse dient zum NICHT-Loggen an Stellen, wo zwingend ein Logger verlangt wird.
 *
 * @version 1.01     2018-07-03
 * @author Christian Dühl
 */

public class NoLogger implements Logger {

    /** Hier wird NICHT geloggt! */
    @Override
    public void log(String text) {
        // wir tun nichts!
    }

    /** Hier wird NICHT geloggt! */
    @Override
    synchronized
    public void log(String text, int stacktraceOffset) {
        // wir tun nichts!
    }

    /** Getter für den Dateinamen. */
    @Override
    public String getLogFileName() {
        throw new RuntimeException("Der NoLogger schreibt in keine Datei!");
    }

    /** Gibt den Pfad zurück, in dem die Logdatei liegt. */
    @Override
    public String getLogPath() {
        throw new RuntimeException("Der NoLogger schreibt in keine Datei!");
    }

    /**
     * Gibt die zuletzt geschriebene Zeilennummer (oder anders gesagt die Anzahl an Zeilen im
     * Logger) zurück.
     *
     * @return Zeilennummer der zuletzt geschriebenen Zeile.
     */
    @Override
    public int getLastWrittenLineNumber() {
        throw new RuntimeException("Der NoLogger schreibt in keine Datei!");
    }

}
