package de.duehl.basics.logic;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Interface steht für eine Klasse, die Fehler behandelt.
 *
 * @version 1.01     2013-12-12
 * @author Christian Dühl
 */

public interface ErrorHandler {

    /** Gibt eine Warnung aus. */
    void warning(String message);

    /**
     * Gibt einen Fehler aus.
     *
     * @param message
     *            Text der Fehlermeldung.
     */
    void error(String message);

    /**
     * Zeigt dem Benutzer einen Fehler mit Exception an.
     *
     * @param message
     *            Text der Fehlermeldung.
     * @param exception
     *            Aufgetretene Ausnahme.
     */
    void error(String message, Exception exception);

}
