package de.duehl.basics.replacements.data;

/*
 * Copyright 2022 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse steht für einen gefundenen Platzhalter der Form <<begriff:1>>.
 *
 * @version 1.01     2022-11-07
 * @author Christian Dühl
 */

public class FoundPlaceholder {

    private final int index;
    private final String placeholder;
    private final String name;
    private final int position;
    private String replacedText;

    public FoundPlaceholder(int index, String placeholder, String name, int position) {
        this.index = index;
        this.placeholder = placeholder;
        this.name = name;
        this.position = position;
        replacedText = "";
    }

    public int getIndex() {
        return index;
    }

    public String getPlaceholder() {
        return placeholder;
    }

    public String getName() {
        return name;
    }

    public int getPosition() {
        return position;
    }

    public String getReplacedText() {
        return replacedText;
    }

    public void setReplacedText(String replacedText) {
        this.replacedText = replacedText;
    }

    @Override
    public String toString() {
        return "FoundPlaceholder [index=" + index + ", placeholder=" + placeholder + ", name="
                + name + ", position=" + position + ", replacedText=" + replacedText + "]";
    }

}
