package de.duehl.basics.datetime.date.parse;

/*
 * Copyright 2018 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.datetime.date.ImmutualDate;

public class DateParseMethodTwoDigitYearTest {

    @Test
    public void parseNormalCase() {
        DateParseMethod method = new DateParseMethodTwoDigitYear("11.02.18");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(11, date.getDay());
        assertEquals(2, date.getMonth());
        assertEquals(2018, date.getYear());

        assertTrue(date.isValid());
    }

    @Test
    public void parseNormalCaseWithBlanks() {
        DateParseMethod method = new DateParseMethodTwoDigitYear("11. 02.    18");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(11, date.getDay());
        assertEquals(2, date.getMonth());
        assertEquals(2018, date.getYear());

        assertTrue(date.isValid());
    }

    @Test
    public void parseNormalOneDigitMonthCase() {
        DateParseMethod method = new DateParseMethodTwoDigitYear("11.2.18");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(11, date.getDay());
        assertEquals(2, date.getMonth());
        assertEquals(2018, date.getYear());

        assertTrue(date.isValid());
    }

    @Test
    public void parseNormalCaseOneDigitMonthOneDigitDay() {
        DateParseMethod method = new DateParseMethodTwoDigitYear("1.1.18");
        method.parse();

        assertTrue(method.isSuccessfull());

        ImmutualDate date =method.getParsedDate();

        assertEquals(1, date.getDay());
        assertEquals(1, date.getMonth());
        assertEquals(2018, date.getYear());

        assertTrue(date.isValid());
    }

}
