package de.duehl.basics.io;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.io.data.InputOutput;

public class InputOutputTest {

    @Test
    public void create() {
        InputOutput io = new InputOutput("foo", "bar");
        assertNotNull(io);
    }

    @Test
    public void getInput() {
        InputOutput io = new InputOutput("foo", "bar");
        String actual = io.getInput();
        String expected = "foo";
        assertEquals(expected, actual);
    }

    @Test
    public void getOutput() {
        InputOutput io = new InputOutput("foo", "bar");
        String actual = io.getOutput();
        String expected = "bar";
        assertEquals(expected, actual);
    }

    @Test
    public void testToString() {
        InputOutput io = new InputOutput("foo", "bar");
        String actual = io.toString ();
        String expected = "InputOutput [input=foo, output=bar]";
        assertEquals(expected, actual);
    }

}
