package de.duehl.basics.logging.eraser;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.test.OutAndErrStreamHandlingTest;
import de.duehl.basics.text.Text;

public class StdOutLoggerTest extends OutAndErrStreamHandlingTest {

    @Test
    public void create() {
        StdOutLogger logger = new StdOutLogger();
        assertNotNull(logger);
    }

    @Test
    public void logFullLine() {
        StdOutLogger logger = new StdOutLogger();
        logger.log("test");
        String actual = getOutContents();
        String expected = "test" + Text.LINE_BREAK;
        assertEquals(expected, actual);
    }

    @Test
    public void logWithIndex() {
        StdOutLogger logger = new StdOutLogger();
        logger.log("test", 0);
        String actual = getOutContents();
        String expected = "test" + Text.LINE_BREAK;
        assertEquals(expected, actual);
    }

    @Test (expected = RuntimeException.class)
    public void getLogFileName() {
        StdOutLogger logger = new StdOutLogger();
        logger.getLogFileName();
    }

    @Test (expected = RuntimeException.class)
    public void getLogPath() {
        StdOutLogger logger = new StdOutLogger();
        logger.getLogPath();
    }

}
