package de.duehl.basics.start;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.proccess.ExternalBatch;

public class ExternalBatchTestCreateFileBatch {

    private static final String PATH = "c:/temp/";
    private static final String NAME_PRE = "externalBatchTestCreateFileBatch";

    private final String outputFile;

    public ExternalBatchTestCreateFileBatch () {
        outputFile = FileHelper.concatPathes(PATH, NAME_PRE + ".output");
        deleteOutputFile();
    }

    private void deleteOutputFile() {
        FileHelper.deleteFileIfExistent(outputFile);
    }

    private void run() {
        ExternalBatch batch = new ExternalBatch("@echo huhu > " + outputFile);
        batch.createRunWaitAndHandleErrors();
    }

    public static void main(String[] args) {
        new ExternalBatchTestCreateFileBatch().run();
    }
}
