package de.duehl.basics.start;

import de.duehl.basics.io.FileHelper;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.io.zip.ZipDirectories;

public class TestingZipping {

    public static void main(String[] args) {
        String dir = "c:/temp/zipping_test";
        String back = "_2";

        String dir1 = FileHelper.concatPathes(dir, "daten1");
        String dir2 = FileHelper.concatPathes(dir, "daten2");

        String zipFilename1 = FileHelper.concatPathes(dir, "foo1" + back + ".zip");
        String zipFilename2 = FileHelper.concatPathes(dir, "foo2" + back + ".zip");
        String zipFilename1Ohne = FileHelper.concatPathes(dir, "foo1_ohne" + back + ".zip");
        String zipFilename1MitDatum = FileHelper.concatPathes(dir, "foo1_datum" + back + ".zip");

        ZipDirectories zip = new ZipDirectories();
        zip.zipDirectory(zipFilename1, dir1);
        zip.zipMultipleDirectories(zipFilename2, dir1, dir2);

        ZipDirectories zipOhne = new ZipDirectories(false);
        zipOhne.zipDirectory(zipFilename1Ohne, dir1);

        ZipDirectories zipDatum = new ZipDirectories();
        zipDatum.changeCreationLastAccessAndModificationTime("24.12.2023", "17:30:00");
        zipDatum.zipDirectory(zipFilename1MitDatum, dir1);
    }

}
