package de.duehl.basics.system;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.text.Text;

public class OutputStreamSaveAndReleaseTest {

    private static final boolean RUN_PRINTING_TEST = false;

    @Test (expected = RuntimeException.class)
    public void failOnSaveReleaseAndGetOut() {
        OutputStreamSaveAndRelease osar = new OutputStreamSaveAndRelease();
        osar.saveSystemOut();
        String text = "Hallo Welt!";
        System.out.println(text);
        osar.releaseSystemOut();
        osar.getOutContents();
    }

    @Test
    public void saveGetOutAndRelease() {
        OutputStreamSaveAndRelease osar = new OutputStreamSaveAndRelease();
        osar.saveSystemOut();
        String text = "Hallo Welt!";
        System.out.println(text);
        String actual = osar.getOutContents();
        osar.releaseSystemOut();
        String expected = text + Text.LINE_BREAK;
        assertEquals(expected, actual);
    }

    @Test (expected = RuntimeException.class)
    public void failOnSaveReleaseAndGetErr() {
        OutputStreamSaveAndRelease osar = new OutputStreamSaveAndRelease();
        osar.saveSystemErr();
        String text = "Hallo Welt!";
        System.err.println(text);
        osar.releaseSystemErr();
        osar.getErrContents();
    }

    @Test
    public void saveGetErrAndRelease() {
        OutputStreamSaveAndRelease osar = new OutputStreamSaveAndRelease();
        osar.saveSystemErr();
        String text = "Hallo Welt!";
        System.err.println(text);
        String actual = osar.getErrContents();
        osar.releaseSystemErr();
        String expected = text + Text.LINE_BREAK;
        assertEquals(expected, actual);
    }

    @Test
    public void saveOutAndPrintToSavedOut() {
        if (RUN_PRINTING_TEST) {
            OutputStreamSaveAndRelease osar = new OutputStreamSaveAndRelease();
            osar.saveSystemOut();
            String text = "Hallo Welt!";
            osar.printOut(text);
            String actual = osar.getOutContents();
            osar.releaseSystemOut();
            String expected = "";
            assertEquals(expected, actual);
        }
    }

}
