package de.duehl.basics.text.html.generation;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import static de.duehl.basics.text.html.generation.SwingHtmlBuilder.*;

public class SwingHtmlBuilderTest {

    @Test
    public void appendLocalColoredGreenP() {
        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredGreenP("grün")
                ;

        String actual = html.toString();
        String expected = ""
                + "<p style=\"color:#00A000\">grün</p>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredRedP() {
        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredRedP("rot")
                ;

        String actual = html.toString();
        String expected = ""
                + "<p style=\"color:#ff0000\">rot</p>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredOrangeP() {
        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredOrangeP("orange")
                ;

        String actual = html.toString();
        String expected = ""
                + "<p style=\"color:#ff6600\">orange</p>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalLargeP() {
        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalLargeP("Groß")
                ;

        String actual = html.toString();
        String expected = ""
                + "<p style=\"font-size:large\">Groß</p>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalSmallP() {
        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalSmallP("Klein")
                ;

        String actual = html.toString();
        String expected = ""
                + "<p style=\"font-size:x-small\">Klein</p>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalTtSpan() {
        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalTtSpan("Monospaced")
                ;

        String actual = html.toString();
        String expected = ""
                + "<span style=\"font-family: monospace;\">Monospaced</span>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredRedP2() {
        String text = "TEXT";

        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredRedP(text)
                ;

        String actual = html.toString();
        String expected = "<p style=\"color:#ff0000\">" + text + "</p>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredOrangeP2() {
        String text = "TEXT";

        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredOrangeP(text)
                ;

        String actual = html.toString();
        String expected = "<p style=\"color:#ff6600\">" + text + "</p>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredGreenP2() {
        String text = "TEXT";

        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredGreenP(text)
                ;

        String actual = html.toString();
        String expected = "<p style=\"color:#00A000\">" + text + "</p>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredP() {
        String text = "TEXT";
        String hexColor = "HEX_COLOR";

        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredP(text, hexColor)
                ;

        String actual = html.toString();
        String expected = "<p style=\"color:#" + hexColor + "\">" + text + "</p>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredH1() {
        String text = "TEXT";
        String hexColor = "HEX_COLOR";

        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredH1(text, hexColor)
                ;

        String actual = html.toString();
        String expected = ""
                + "<h1 id=\"id1\" style=\"color:#" + hexColor + "\">" + text + "</h1>" + n
                ;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredH2() {
        String text = "TEXT";
        String hexColor = "HEX_COLOR";

        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredH2(text, hexColor)
                ;

        String actual = html.toString();
        String expected = ""
                + "<h2 id=\"id0_1\" style=\"color:#" + hexColor + "\">" + text + "</h2>" + n
                ;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredH3() {
        String text = "TEXT";
        String hexColor = "HEX_COLOR";

        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredH3(text, hexColor)
                ;

        String actual = html.toString();
        String expected = ""
                + "<h3 id=\"id0_0_1\" style=\"color:#" + hexColor + "\">" + text + "</h3>" + n
                ;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredH4() {
        String text = "TEXT";
        String hexColor = "HEX_COLOR";

        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredH4(text, hexColor)
                ;

        String actual = html.toString();
        String expected = ""
                + "<h4 id=\"id0_0_0_1\" style=\"color:#" + hexColor + "\">" + text + "</h4>" + n
                ;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredH5() {
        String text = "TEXT";
        String hexColor = "HEX_COLOR";

        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredH5(text, hexColor)
                ;

        String actual = html.toString();
        String expected = ""
                + "<h5 id=\"id0_0_0_0_1\" style=\"color:#" + hexColor + "\">" + text + "</h5>" + n
                ;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredH6() {
        String text = "TEXT";
        String hexColor = "HEX_COLOR";

        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredH6(text, hexColor)
                ;

        String actual = html.toString();
        String expected = ""
                + "<h6 id=\"id0_0_0_0_0_1\" style=\"color:#" + hexColor + "\">" + text + "</h6>" + n
                ;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredLi() {
        String text = "TEXT";
        String hexColor = "HEX_COLOR";

        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredLi(text, hexColor)
                ;

        String actual = html.toString();
        String expected = "<li style=\"color:#" + hexColor + "\">" + text + "</li>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredGreenSpan() {
        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredGreenSpan("grün")
                ;

        String actual = html.toString();
        String expected = ""
                + "<span style=\"color:#00A000\">grün</span>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredRedSpan() {
        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredRedSpan("rot")
                ;

        String actual = html.toString();
        String expected = ""
                + "<span style=\"color:#ff0000\">rot</span>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredOrangeSpan() {
        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredOrangeSpan("orange")
                ;

        String actual = html.toString();
        String expected = ""
                + "<span style=\"color:#ff6600\">orange</span>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalColoredSpan() {
        String text = "TEXT";
        String hexColor = "HEX_COLOR";

        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendLocalColoredSpan(text, hexColor)
                ;

        String actual = html.toString();
        String expected = "<span style=\"color:#" + hexColor + "\">" + text + "</span>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendTdLocalRight() {
        String text = "TEXT";

        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendTdLocalRight(text)
                ;

        String actual = html.toString();
        String expected = "<td style=\"text-align:right;\">" + text + "</td>" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendOpeningTagWithStyle() {
        String tag = "TAG";
        String style = "STYLE";
        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendOpeningTagWithStyle(tag, style)
                ;

        String actual = html.toString();
        String expected = ""
                + "<" + tag + " style=\"" + style + "\">" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendOpeningDivWithStyle() {
        String style = "STYLE";
        SwingHtmlBuilder html = new SwingHtmlBuilder()
                .appendOpeningDivWithStyle(style)
                ;

        String actual = html.toString();
        String expected = ""
                + "<div style=\"" + style + "\">" + n;
        assertEquals(expected, actual);
    }

    @Test
    public void appendLocalBackgroundColoredDiv() {
        String hexColor = "AABBCC";
        SwingHtmlBuilder html = new SwingHtmlBuilder().appendLocalBackgroundColoredDiv(hexColor);

        String actual = html.toString();
        String expected = ""
                + "<div style=\"background:#" + hexColor + "\">" + n;
        assertEquals(expected, actual);
    }

}
