package de.duehl.swing.logic;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Dieses Interface hält Methoden vor, die über den Start bzw. das Ende eines
 * länger laufenden Prozesses informieren.
 *
 * @version 1.01     2017-11-23
 * @author Christian Dühl
 */

public interface LongTimeProcessInformer {

    /**
     * Startet einen Prozess, der eine Weile braucht.
     *
     * @param message
     *            Anzuzeigende Nachricht.
     */
    void startLongTimeProcess(String message);

    /** Beendet einen Prozess, der eine Weile braucht. */
    void endLongTimeProcess();

}
