package de.duehl.swing.ui.buttons;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.SwingConstants;

import static de.duehl.swing.ui.buttons.ButtonHelper.TOGGLE_BUTTON_MOUSE_LISTENER;

/**
 * Diese Klasse stellt einen kleinen Button mit wenig Text dar.
 *
 * @version 1.01     2015-02-05
 * @author Christian Dühl
 */

public class TextButton extends JButton {

    private static final long serialVersionUID = -466500830104847789L;

    /**
     * Konstruktor.
     *
     * @param title
     *            Anzuzeigender Text.
     */
    public TextButton(String title) {
        super(title);
        setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        //setPreferredSize(new Dimension(100, 17));
        setHorizontalAlignment(SwingConstants.LEFT);
        setContentAreaFilled(false);

        setFocusable(false);
        setBorder(BorderFactory.createEtchedBorder());
        setBorderPainted(false);
        //setBorder(null); // Das verhindert den Rahmen bei Mouseover!

        addMouseListener(TOGGLE_BUTTON_MOUSE_LISTENER);
        setRolloverEnabled(true);
    }

}
