package de.duehl.swing.ui.components.elements;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;

/**
 * Diese Klasse stellt ein Element mit einer Überschrift links und einem frei bearbeitbaren Text
 * rechts daneben dar.
 *
 * @version 1.01     2019-05-23
 * @author Christian Dühl
 */

public class HorizontalTextFieldWithTitle extends TextFieldWithTitle {

    public HorizontalTextFieldWithTitle(String title) {
        super(title);
    }

    @Override
    protected String getTitleBorderLayoutOrientation() {
        return BorderLayout.WEST;
    }

    @Override
    protected String getTextFieldBorderLayoutOrientation() {
        return BorderLayout.CENTER;
    }

}
