package de.duehl.swing.ui.components.selections.data;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt die Suchparameter eines Suchfelds (SearchWordStringSelection) dar.
 *
 * @version 1.01     2024-08-22
 * @author Christian Dühl
 */

public class SearchWordSelectionInputs {

    /** Der angezeigte Text, also der Suchbegriff. */
    private String text;

    /** Gibt an, ob die Suche nach ganzen Worten erfolgen soll. */
    private boolean wholeWordSearch;

    /** Gibt an, ob die Suche Groß-/Kleinschreibung berücksichtigen soll. */
    private boolean caseSensitiveSearch;

    /** Konstruktor. */
    public SearchWordSelectionInputs() {
        text = "";
        wholeWordSearch = false;
        caseSensitiveSearch = false;
    }

    /** Getter für den angezeigten Text, also den Suchbegriff. */
    public String getText() {
        return text;
    }

    /** Setter für den angezeigten Text, also den Suchbegriff. */
    public void setText(String text) {
        this.text = text;
    }

    /** Gibt an, ob die Suche nach ganzen Worten erfolgen soll. */
    public boolean isWholeWordSearch() {
        return wholeWordSearch;
    }

    /** Legt fest, ob die Suche nach ganzen Worten erfolgen soll. */
    public void setWholeWordSearch(boolean wholeWordSearch) {
        this.wholeWordSearch = wholeWordSearch;
    }

    /** Gibt an, ob die Suche Groß-/Kleinschreibung berücksichtigen soll. */
    public boolean isCaseSensitiveSearch() {
        return caseSensitiveSearch;
    }

    /** Legt fest, ob die Suche Groß-/Kleinschreibung berücksichtigen soll. */
    public void setCaseSensitiveSearch(boolean caseSensitiveSearch) {
        this.caseSensitiveSearch = caseSensitiveSearch;
    }

    /** Gibt an, ob der Text leer ist. */
    public boolean isTextEmpty() {
        return text.isEmpty();
    }

}
