package de.duehl.swing.ui.dragndrop;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;

/**
 * Diese Klasse stellt Hilfsmethoden rund um das Drag & Drop zur Verfügung.
 *
 * @version 1.01     2020-01-24
 * @author Christian Dühl
 */

public class DragNDropManagerHelper {

    /** Bereitet den gezogenen Text aus einem HTML-Dokument zum Einfügen vor. */
    public static String prepareHtmlDraggedString(String draggedText) {
        String text = trimHtmlDraggedString(draggedText);
        text = text.replaceAll("\\s|\r|\n", " "); // eigentlich ist das schon in \s drin, egal
        text = text.replaceAll(" +", " ");
        return text;
    }

    /**
     * Trimmt den gezogenen Text aus einem HTML-Dokument, nachdem &nbsp; in Leerzeichen gewandelt
     * wurde.
     */
    public static String trimHtmlDraggedString(String draggedText) {
        String text = draggedText.replace("&nbsp;", " ");
        text = text.replace("\u00a0", " "); // denn es werden keine normalen Leerzeichen daraus...
        text = text.trim();
        return text;
    }

    /** Splittet den Text zunächst an den Zeilenumbrüchen und bereitet dann jede Zeile einzeln auf. */
    public static List<String> splitAndPrepareHtmlDraggedString(String draggedText) {
        List<String> rawLines = Text.splitByLineBreaks(draggedText);
        List<String> preparedLines = new ArrayList<>();

        for (String rawLine : rawLines) {
            String preparedLine = prepareHtmlDraggedString(rawLine);
            preparedLines.add(preparedLine);
        }

        CollectionsHelper.removeEmptyStringsAtFrontOfList(preparedLines);
        CollectionsHelper.removeEmptyStringsAtEndOfList(preparedLines);

        return preparedLines;
    }

}
