package de.duehl.swing.ui.highlightingeditor.changestate;

import de.duehl.basics.debug.DebugHelper;
import de.duehl.swing.ui.highlightingeditor.multiplereactor.ChangeReactor;
import de.duehl.swing.ui.tabs.ChangeStateDisplayer;

/**
 * Diese Klasse hält für den Editor selbst die Information darüber fest, ob sein Inhalt verändert
 * oder unverändert ist.
 *
 * @version 1.01     2017-12-19
 * @author Christian Dühl
 */

public class EditorChangeState implements ChangeStateDisplayer, ChangeReactor {

    private final static boolean DEBUG = false;

    private boolean changed = false;
    private boolean reactOnChanges = false;

    @Override
    public void reactOnChanges() {
        say("reactOnChanges()");
        reactOnChanges  = true;
    }

    @Override
    public void doNotReactOnChanges() {
        say("doNotReactOnChanges()");
        reactOnChanges = false;
    }

    @Override
    public void signChangedState() {
        say("signChangedState() - reactOnChanges = " + reactOnChanges);
        if (reactOnChanges) {
            changed = true;
            say("signChangedState() - changed = " + changed);
        }
    }

    @Override
    public void signUnchangedState() {
        say("signUnchangedState() - reactOnChanges = " + reactOnChanges);
        if (reactOnChanges) {
            changed = false;
            say("signChangedState() - changed = " + changed);
        }
    }

    @Override
    public void updateName(String newName) {
        // interessiert uns nicht
    }

    /** Gibt an, ob der Inhalt des Editors geändert wurde. */
    public boolean isChanged() {
        return changed;
    }

    private void say(String message) {
        if (DEBUG) {
            DebugHelper.sayWithClassAndMethodAndTime(message);
        }
    }

}
