package de.duehl.swing.ui.highlightingeditor.contextmenu;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.event.MouseAdapter;

public interface EditorForContextMenu {

    /** Wählt den gesamten Text aus. */
    void selectAll();

    /** Gibt den selektierten Text zurück. */
    String getSelectedText();

    /** Selection ausschneiden. */
    void cutSelection();

    /** Selection kopieren. */
    void copySelection();

    /** Inhalt der Zwischenablage einfügen. */
    void insertSelection();

    /** Fügt einen MouseListener hinzu, damit man erkennen kann, ob was selektiert ist. */
    void addMouseListener(MouseAdapter adapter);

}
