package de.duehl.swing.ui.highlightingeditor.syntax;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.List;

/**
 * Diese Klasse stellt eine Menge von zusammengehörigen Begriffen der Syntax-Hervorhebung des
 * bearbeitbaren Editors mit Syntax-Highlighting dar.
 *
 * @version 1.01     2017-11-15
 * @author Christian Dühl
 */

public class HighlightingTokens {

    /** Liste der Begriffe für diese Art der Syntax-Hervorhebung. */
    private final List<String> tokens;

    /** Für diese Begriffe verwendete Art der Syntax-Hervorhebung. */
    private final HighlightingType highlightingType;

    /**
     * Konstruktor.
     *
     * @param highlightingType
     *            Für diese Begriffe verwendete Art der Syntax-Hervorhebung.
     */
    public HighlightingTokens(HighlightingType highlightingType) {
        tokens = new ArrayList<>();
        this.highlightingType = highlightingType;
    }

    /** Fügt einen Begriff zur Sammlung hinzu. */
    public void addToken(String token) {
        tokens.add(token);
    }

    /** Getter für die Liste der Begriffe für diese Art der Syntax-Hervorhebung. */
    public List<String> getTokens() {
        return tokens;
    }

    /** Getter für die verwendete Art der Syntax-Hervorhebung. */
    public HighlightingType getHighlightingType() {
        return highlightingType;
    }

    /** Gibt an, ob Treffer auch Wortteile auszeichnen. */
    public boolean isMarkInWordParts() {
        return highlightingType.isMarkInWordParts();
    }

}
