package de.duehl.swing.ui.highlightingeditor.syntax.highlighting;

import java.awt.Color;
import java.util.List;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.swing.ui.colors.NamedColorListFabric;
import de.duehl.swing.ui.highlightingeditor.syntax.HighlightingTokens;
import de.duehl.swing.ui.highlightingeditor.syntax.HighlightingType;
import de.duehl.swing.ui.highlightingeditor.syntax.SyntaxHighlighting;

/**
 * Diese Klasse stellt das Java Syntax-Highlighting dar.
 *
 * @version 1.01     2017-11-23
 * @author Christian Dühl
 */

class JavaSyntaxHighlighting implements Highlighting {

    private final SyntaxHighlighting sytaxHighlighting;

    JavaSyntaxHighlighting() {
        HighlightingType keywordsHighlightingType = createKeywordHighlightingType();
        HighlightingType symbolsHighlightingType = createSymbolHighlightingType();
        sytaxHighlighting = new SyntaxHighlighting(keywordsHighlightingType,
                symbolsHighlightingType);

        addKeywords();
        addSymbols();
        addOther();
    }

    private static HighlightingType createKeywordHighlightingType() {
        return new HighlightingType(createColor(NamedColorListFabric.AUBERGINE), true);
    }

    private static HighlightingType createSymbolHighlightingType() {
        return new HighlightingType(createColor(NamedColorListFabric.FORESTGREEN), false, true);
    }

    private static Color createColor(String colorName) {
        return new NamedColorListFabric().getColorByName(colorName);
    }

    private void addKeywords() {
        List<String> keywords = CollectionsHelper.buildListFrom("abstract", "assert", "boolean",
                "break", "byte", "case", "catch", "char", "class", "const", "continue", "default",
                "do", "double", "else", "enum", "exports", "extends", "final", "finally", "float",
                "for", "goto", "if", "implements", "import", "instanceof", "int", "interface",
                "long", "module", "native", "new", "open", "opens", "package", "private",
                "protected", "provides", "public", "requires", "return", "short", "static",
                "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "to",
                "transient", "transitive", "try", "uses", "void", "volatile", "while", "with");

        for (String keyword : keywords) {
            sytaxHighlighting.addKeyword(keyword);
        }
    }

    private void addSymbols() {
        List<String> symbols = CollectionsHelper.buildListFrom("+", "-", ":", ",", "=", ";", "!",
                "(", ")", "[", "]", "{", "}", "'", "\"");

        for (String symbol : symbols) {
            sytaxHighlighting.addSymbol(symbol);
        }
    }

    private void addOther() {
        //addOther(NamedColorListFabric.RED, "foo", "bar", "baz");
    }

    @SuppressWarnings("unused")
    private void addOther(String colorName, String ... parts) {
        HighlightingType type = new HighlightingType(createColor(colorName), true, false);

        HighlightingTokens tokens = new HighlightingTokens(type);
        for (String part : parts) {
            tokens.addToken(part);
        }
        sytaxHighlighting.addOtherHighlightingTokens(tokens);
    }

    @Override
    public SyntaxHighlighting create() {
        return sytaxHighlighting;
    }

}
