package de.duehl.swing.ui.key;

import de.duehl.swing.ui.menu.collection.tools.MyMenuItemCollectionHelper;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Oft definiert man in einem Menü Tastaturbefehle, die dann aber nicht
 * funktionieren, wenn der Focus auf z.B. einer JEditorPane liegt.              <br><br>
 *
 * Diese Klasse dient zur Speicherung von einem Tastaturbefehl.
 *
 * @version 1.01     2021-04-21
 * @author Christian Dühl
 */

public class KeyDefinition {

    public static final KeyDefinition NO_KEY_DEFINIED = new KeyDefinition(Integer.MAX_VALUE,
            Integer.MAX_VALUE);

    public static final String NO_KEYBOARD_SHORTCUT_DEFFINED = "NO KEYBOARD SHORTCUT DEFFINED";

    private final int keyCode;
    private final int modifiers;

    public KeyDefinition(int keyCode, int modifiers) {
        this.keyCode = keyCode;
        this.modifiers = modifiers;
    }

    public int getKeyCode() {
        return keyCode;
    }

    public int getModifiers() {
        return modifiers;
    }

    public boolean isDefined() {
        return !this.equals(NO_KEY_DEFINIED);
    }

    public String toReadableString() {
        if (isDefined()) {
            return MyMenuItemCollectionHelper.generateKeyboardCommandDescription(this);
        }
        else {
            return NO_KEYBOARD_SHORTCUT_DEFFINED;
        }
    }

    @Override
    public String toString() {
        String readable = toReadableString();
        return "KeyDefinition [" + readable + "]";
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + keyCode;
        result = prime * result + modifiers;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        KeyDefinition other = (KeyDefinition) obj;
        if (keyCode != other.keyCode)
            return false;
        if (modifiers != other.modifiers)
            return false;
        return true;
    }

}
