package de.duehl.swing.ui.layout;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;

import javax.swing.JPanel;

/**
 * Diese Klasse erstellt einen JPanel, der Dinge vertikal untereinander anordnet.
 * Bei pack() scheint das VerticalLayout nämlich nicht zu funktionieren.
 *
 * @version 1.01     2019-05-28
 * @author Christian Dühl
 */

public class VerticalLayouter {

    private final JPanel panel;
    private JPanel lowestPanel;

    public VerticalLayouter() {
        panel = createPanel();
        lowestPanel = panel;
    }

    private JPanel createPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());

        return panel;
    }

    public void add(Component component) {
        lowestPanel.add(component, BorderLayout.NORTH);
        JPanel newLowestPanel = createPanel();
        lowestPanel.add(newLowestPanel, BorderLayout.CENTER);
        lowestPanel = newLowestPanel;
    }

    public JPanel getPanel() {
        return panel;
    }

}
