package de.duehl.swing.ui.layout.card;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Component;

/**
 * Dieses Interface wird von den Klassen mit den grafischen Oberflächen der Karten implementiert.
 *
 * @version 1.01     2016-12-07
 * @author Christian Dühl
 */

public interface CardGui {

    /** Setter für die zur grafischen Oberfläche gehörigen Logik. */
    void setLogic(CardLogic logic);

    /**
     * Erzeugt die grafisch Oberfläche für diese Karte.
     *
     * @param switcher
     *            Objekt zum Weiterschalten auf die nächste Karte bzw. zum Beenden des Programms.
     */
    Component createGui(CardSwitcher switcher);

    /** Räumt auf, nachdem die Karte nicht mehr angezeigt wird. */
    void cleanUp();

}
